/** @type {import('tailwindcss').Config} */

const flowbite = require("flowbite-react/tailwind");

module.exports = {
  content: [
    "./pages/**/*.{js,ts,jsx,tsx,mdx}",
    "./components/**/*.{js,ts,jsx,tsx,mdx}",
    "./app/**/*.{js,ts,jsx,tsx,mdx}",
    flowbite.content(),
  ],
  theme: {
    extend: {
      colors: {
        background: "var(--background)",
        foreground: "var(--foreground)",
        bgColor: "#003940",
        litegreen: "#3FC088",
        primary: {
          light: "#30E496",
          DEFAULT: "#3FC088",
        },
        secondary: "#05464F",
      },
      screens: {
        "3xl": "1800px",
      },
    },
    fontFamily: {
      sans: ["Poppins", "sans-serif"],
      display: ["Noto Sans", "sans-serif"],
    },
  },

  plugins: [flowbite.plugin()],
};
