import localFont from "next/font/local";
import "./globals.scss";
import Topbar from "./component/Topbar";
import { ButtonGroup } from "./component/Button";
import Footer from "./component/footer";
import GoTop from "./component/Button/GoTop";

// const geistSans = localFont({
//   src: "./fonts/GeistVF.woff",
//   variable: "--font-geist-sans",
//   weight: "100 900",
// });
// const geistMono = localFont({
//   src: "./fonts/GeistMonoVF.woff",
//   variable: "--font-geist-mono",
//   weight: "100 900",
// });
const getPopins = localFont({
  src: "./fonts/Poppins-Regular.ttf",
  variable: "--font-popins",
  weight: "100 900",
});

export const metadata = {
  title: "Create Next App",
  description: "Generated by create next app",
};

export default function RootLayout({ children }) {

  return (
    <html lang="en">
      <body
        className={`${getPopins.variable}  bg-bgColor antialiased`}
      >
        <ButtonGroup />

        <GoTop/>
        <Topbar/>
        <main className="mt-[136px]">
          {children}
        </main>
        <Footer/>
      </body>
    </html>
  );
}
