import React from 'react'

const highlightTitleInDescription = (description, title) => {
    const parts = description.split(new RegExp(`(${title})`, "gi"));
    return parts.map((part, index) =>
      part.toLowerCase() === title.toLowerCase() ? (
        <span key={index} style={{ color: "#30E496", fontWeight: "bold" }}>
          {part}
        </span>
      ) : (
        part
      )
    );
  };

export default highlightTitleInDescription
