import React, { useState } from 'react'
import { GoogleMap, useJsApiLoader, Marker, InfoWindow } from '@react-google-maps/api'

const containerStyle = {
  width: '590px',
  height: '580px',
}

const center = {
  lat: 23.781015,
  lng: 90.3998979,
}

function MyGoogleMap() {
  const { isLoaded } = useJsApiLoader({
    id: 'google-map-script',
    googleMapsApiKey: 'AIzaSyDc5XpozFMsNcaK6BxU2BRBkaivcf2FIyU',
  })

  const [map, setMap] = useState(null)
  const [infoWindowOpen, setInfoWindowOpen] = useState(false) // State to control InfoWindow visibility
  const [markerPosition, setMarkerPosition] = useState(center) // Store marker position

  const onLoad = React.useCallback(function callback(map) {
    setMap(map)
  }, [])

  const onUnmount = React.useCallback(function callback(map) {
    setMap(null)
  }, [])

  // Handle marker click
  const handleMarkerClick = () => {
    setInfoWindowOpen(true)
  }

  // Handle InfoWindow close
  const handleInfoWindowClose = () => {
    setInfoWindowOpen(false)
  }

  return isLoaded ? (
    <GoogleMap
      mapContainerStyle={containerStyle}
      center={center}
      zoom={15} // Initial zoom level set to 15 for street mode
      onLoad={onLoad}
      onUnmount={onUnmount}
    >
      {/* Adding a Marker at the center position */}
      <Marker position={markerPosition} onClick={handleMarkerClick} />

      {/* InfoWindow that shows when the marker is clicked */}
      {infoWindowOpen && (
        <InfoWindow position={markerPosition} onCloseClick={handleInfoWindowClose}>
          <div>
            <h4>ADN TELECOM LTD</h4>
            <p>Address: House No. 123, Road No. 456, Dhaka, Bangladesh</p>
          </div>
        </InfoWindow>
      )}
    </GoogleMap>
  ) : (
    <></>
  )
}

export default React.memo(MyGoogleMap)
