import Container from "./Container";
import Image from "next/image"; // Assuming you are using Next.js
import bgimg from "../images/bg.png";

const NumbersAtGlance = () => {
  return (
    <>
      <section className="marginTop relative">
        {/* Background Image */}
        <Image
          src={bgimg}
          alt="Background Image"
          layout="fill"
          objectFit="cover"
          className="z-0"
        />
       

        {/* Content Section */}
        <div className="stats relative mx-auto py-[120px]">
          <div className="mx-auto max-w-screen-2xl px-8">
            <div className="grid grid-cols-1 gap-16 text-white md:grid-cols-2">
              {/* Title */}
              <h1 className="w-full text-center  md:w-[320px] md:text-left text-h2">
                <span className="text-[#3FC088]">Numbers</span> At a Glance
              </h1>

              {/* Stats */}
              <div className="grid grid-cols-1 gap-16 md:grid-cols-2 lg:gap-y-36">
                {/* Map the items */}
                <div className="flex flex-col items-center justify-center md:block">
                  <h2 className="relative text-4xl font-bold after:absolute after:bottom-[-20px] after:left-0 after:border-b-[5px] after:border-[#3FC088] after:content-[''] lg:text-7xl lg:after:w-1/4">
                    2003
                  </h2>
                  <p className="mt-8 text-center text-lg font-medium text-[#ccc] md:text-left">
                    Commencement of Business
                  </p>
                </div>

                <div className="flex flex-col items-center justify-center md:block">
                  <h2 className="relative text-4xl font-bold after:absolute after:bottom-[-20px] after:left-0 after:w-1/4 after:border-b-[5px] after:border-[#3FC088] after:content-[''] lg:text-7xl">
                    500+
                  </h2>
                  <p className="mt-8 text-center text-lg font-medium text-[#ccc] md:text-left">
                    Number of employees
                  </p>
                </div>

                <div className="flex flex-col items-center justify-center md:block">
                  <h2 className="relative text-4xl font-bold after:absolute after:bottom-[-20px] after:left-0 after:w-1/4 after:border-b-[5px] after:border-[#3FC088] after:content-[''] lg:text-7xl">
                    50+
                  </h2>
                  <p className="mt-8 text-center text-lg font-medium text-[#ccc] md:text-left">
                    Global Locations
                  </p>
                </div>

                <div className="flex flex-col items-center justify-center md:block">
                  <h2 className="relative text-4xl font-bold after:absolute after:bottom-[-20px] after:left-0 after:w-1/4 after:border-b-[5px] after:border-[#3FC088] after:content-[''] lg:text-7xl">
                    1000+
                  </h2>
                  <p className="mt-8 text-center text-lg font-medium text-[#ccc] md:text-left">
                    Projects Completed
                  </p>
                </div>
              </div>
            </div>
          </div>
        </div>
      </section>
    </>
  );
};

export default NumbersAtGlance;
