import Image from "next/image";
import icon from "../images/right-circle.svg"

const GetInTouch = () => {
  return (
    <div className="mx-auto marginTop flex max-w-screen-2xl flex-col items-center justify-center bg-litegreen py-8 text-center lg:py-14">
      <h1 className="mb-4 text-3xl font-bold text-white md:text-5xl">
        Get in touch today
      </h1>
      <p className="mb-8 max-w-[712px] text-base font-medium text-[#39393b]">
        Join today and experience the difference. Dont miss out on the
        opportunity to transform your business.Lets grow together!
      </p>


      <button class="group mb-8 relative inline-flex h-12 items-center justify-center overflow-hidden rounded-md bg-neutral-950 px-6 font-medium text-neutral-200 transition hover:scale-110">
        <span> Get a free quotation</span>
        <div class="absolute inset-0 flex h-full w-full justify-center [transform:skew(-12deg)_translateX(-100%)] group-hover:duration-1000 group-hover:[transform:skew(-12deg)_translateX(100%)]">
          <div class="relative h-full w-8 bg-white/20"></div>
        </div>
      </button>

      <div className="flex flex-wrap items-center justify-center gap-4">
        <div className="item flex items-center gap-1">
          <Image alt="icon" src={icon} />
          <p className="text-sm text-[#07070A]">Affordable Plans for All</p>
        </div>
        <div className="item flex items-center gap-1">
          <Image alt="icon" src={icon} />
          <p className="text-sm text-[#07070A]">Secure and Reliable</p>
        </div>
      </div>
    </div>
  );
}
export default GetInTouch
