import Container from "./Container";
// import logo from "../images/adnlogo.png";
import logo from "../images/adnlogo.svg";
import facebook from "../images/facebook.svg";
import twitterx from "../images/twitter-x.svg";
import youtube from "../images/youtube.svg";
import instagram from "../images/instagram.svg";
import iso from "../images/iso.png";
import artboard from "../images/artboard.svg";
import Image from "next/image";
import Link from "next/link";
const Footer = () => {
  return (
    <>
      <Container>
        <footer className="text-white pt-10 pb-7 marginTop">
          <div className="  ">
            <div className="flex flex-col lg:flex-row justify-center">
              <div className=" w-full lg:w-[450px]">
                <div className="px-6">
                  <a href="#">
                    <Image className="mb-5 h-[50px] w-auto" src={logo} alt="" />
                  </a>

                  <p className="mt-2 max-w-[330px] font-medium">
                    ADN Telecom is a trusted partner in navigating the
                    ever-evolving landscape of Information and Telecommunication
                    technology.
                  </p>

                  <div className="mt-8 flex items-center">
                    <span className="font-medium">Follow Us</span>
                    <Link
                      href="#"
                      className="mx-2 transition-colors duration-300 hover:text-blue-500 dark:hover:text-blue-400"
                      aria-label="Reddit"
                    >
                      <Image src={twitterx} className="h-6 w-auto" />
                    </Link>
                    <Link
                      href="#"
                      className="mx-2 transition-colors duration-300 hover:text-blue-500 dark:hover:text-blue-400"
                      aria-label="Reddit"
                    >
                      <Image src={instagram} className="h-6 w-auto" />
                    </Link>
                    <Link
                      href="#"
                      className="mx-2 transition-colors duration-300 hover:text-blue-500 dark:hover:text-blue-400"
                      aria-label="Reddit"
                    >
                      <Image src={youtube} className="h-6 w-auto" />
                    </Link>
                    <Link
                      href="#"
                      className="mx-2 transition-colors duration-300 hover:text-blue-500 dark:hover:text-blue-400"
                      aria-label="Reddit"
                    >
                      <Image src={facebook} className="h-6 w-auto" />
                    </Link>
                  </div>

                  <div className="-ml-3 mt-5 flex">
                    <Link
                      href="#"
                      className="mx-2 transition-colors duration-300 hover:text-blue-500 dark:hover:text-blue-400"
                      aria-label="Reddit"
                    >
                      <Image src={artboard} className="h-10 w-auto" />
                    </Link>

                    <Link
                      href="#"
                      className="mx-2 transition-colors duration-300 hover:text-blue-500 dark:hover:text-blue-400"
                      aria-label="Reddit"
                    >
                      <Image src={iso} className="h-10 w-auto" />
                    </Link>
                  </div>
                </div>
              </div>

              <div className="mt-6 lg:mt-4 lg:flex-1 px-6 lg:px-0">
                <div className="grid grid-cols-1 gap-6 sm:grid-cols-2 md:grid-cols-3 ">
                  <div>
                    <h3 className="font-medium capitalize dark:text-white">
                      About Us
                    </h3>
                    <Link
                      href="#"
                      className="block font-medium hover:underline"
                    >
                      Product & Services
                    </Link>
                    <Link
                      href="#"
                      className="block font-medium hover:underline"
                    >
                      Investor Informations
                    </Link>
                    <Link
                      href="#"
                      className="block font-medium hover:underline"
                    >
                      Career
                    </Link>
                    <Link
                      href="#"
                      className="block font-medium hover:underline"
                    >
                      Employee Corner
                    </Link>
                  </div>

                  <div>
                    <h3 className="font-medium capitalize dark:text-white">
                      Quick Link
                    </h3>
                    <Link
                      href="#"
                      className="block font-medium hover:underline"
                    >
                      Privacy Policy
                    </Link>
                    <Link
                      href="#"
                      className="block font-medium hover:underline"
                    >
                      Cookie Policy
                    </Link>
                    <Link
                      href="#"
                      className="block font-medium hover:underline"
                    >
                      Terms & Conditions
                    </Link>
                  </div>

                  <div>
                    <h3 className="text-sm capitalize dark:text-white">
                      Contact us
                    </h3>
                    <span className="mt-1 block font-medium hover:underline">
                      +1 526 654 8965
                    </span>
                    <span className="mt-1 block font-medium hover:underline">
                      +1 526 654 8965
                    </span>
                    <span className="mt-1 block font-medium hover:underline">
                      example@email.com
                    </span>

                    <p className="max-w-[180px] text-base font-medium mt-8">
                      Red Crescent Concord Tower (19th Floor) 17, Mohakhali C/A,
                      Dhaka – 1212, Bangladesh.
                    </p>
                  </div>
                </div>
              </div>
            </div>

            <div>
              <p className="text-center text-sm text-[#CFCFCF] mt-8 lg:mt-4 capitalize">
                compyright © Brand 2024 - All rights reserved
              </p>
            </div>
          </div>
        </footer>
      </Container>
    </>
  );
};
export default Footer;
