import Image from "next/image";
import Container from "./Container";
import heroimg from "../images/choose.png";
import check from "../images/check-mark5.svg";

const ChooseUs = () => {
  return (
    <section className="marginTop">
      <Container>
        <div className="mt-40 mx-auto flex flex-col space-y-6 px-6 py-10 lg:h-[32rem] lg:flex-row lg:items-center lg:py-16">
          <div className="flex w-full items-center justify-center lg:w-1/2">
            <Image
              className="h-full w-full rounded-md object-cover lg:max-w-[486px]"
              src={heroimg}
              alt="glasses photo"
            />
          </div>
          <div className="w-full lg:w-1/2">
            <div className="lg:max-w-2xl">
              <h1 className="text-h2">
                <span className="text-primary-light">Reasons to</span> Choose us
              </h1>
              <p className="py-5 text-xl font-bold text-[#D9D9D9] lg:text-3xl">
                Excellence you can trust
              </p>
              <p className="pb-7 text-lg font-normal text-[#D9D9D9]">
                ADN Diginet’s full suite of cloud infrastructure, applications,
                messaging & business automation solutions will help you unleash
                new possibilities. 
              </p>
              <div className="w-full space-y-7">
                <div className="-px-3 flex items-center dark:text-gray-200">
                  <Image src={check} className="h-5 w-auto" />

                  <span className="mx-3 text-lg font-normal text-[#D9D9D9]">
                    Seamless and secured connectivity across the nation
                  </span>
                </div>
                <div className="-px-3 flex items-center dark:text-gray-200">
                  <Image src={check} className="h-5 w-auto" />

                  <span className="mx-3 text-lg font-normal text-[#D9D9D9]">
                    Robust network infrastructure
                  </span>
                </div>
                <div className="-px-3 flex items-center dark:text-gray-200">
                  <Image src={check} className="h-5 w-auto" />

                  <span className="mx-3 text-lg font-normal text-[#D9D9D9]">
                    Worldwide point-to-point and point-to-multiple connectivity
                  </span>
                </div>
                <div className="-px-3 flex items-center dark:text-gray-200">
                  <Image src={check} className="h-5 w-auto" />

                  <span className="mx-3 text-lg font-normal text-[#D9D9D9]">
                    Tailored Solutions
                  </span>
                </div>
              </div>
            </div>
          </div>
        </div>
      </Container>
    </section>
  );
};

export default ChooseUs;
