import Container from "./Container";
import achievement from "../images/achievement.png";
import basis from "../images/basis.png";
import wba from "../images/wba.png";
import ispab from "../images/ispab.png";
import dcci from "../images/dcci.png";
import icsb from "../images/icsb.svg";
import finance from "../images/finance.png";
import Image from "next/image";
import HeaderSubHead from "./HeaderSubHead";
const Achievement = () => {
  let data = {
    title: "AWARDS",
    description: "AWARDS Achievement",
  };
  return (
    <section className="marginTop">
      <Container>
        {/* <h1 className="text-h1 -mt-10">AWARDS</h1> */}
        <HeaderSubHead data={data}/>

        <div class="mx-auto flex flex-col space-y-6 px-6 py-10 lg:h-[32rem] lg:flex-row lg:items-center lg:py-16">
          <div class="w-full text-white lg:w-1/2">
            <div class="">
              {/* <h1 class="text-sub-h1">
                Honoring <span className="text-primary-light">Achievement</span>
              </h1> */}
              <p class="mt-10 text-lg text-[#F0F0F0] lg:max-w-[586px]">
                Grow sales and stay ahead in the competitive market by being
                among the first to benefit from our game-changing solution
              </p>

              <div className="mt-5 flex flex-wrap items-center gap-8">
                <Image src={icsb} className="max-h-[136px] max-w-[234px]" alt=""/>
                <Image src={finance} className="max-h-[136px] max-w-[234px]" alt=""/>
              </div>

              <div className="merbership mt-10">
                <h2 className="text-2xl uppercase lg:text-3xl">Membership</h2>
                <div className="flex flex-wrap gap-2 py-3">
                  <div className="w-full max-w-[31px] border-b-4 border-[#3FC088]"></div>
                  <div className="w-full max-w-[300px] border-b-4 border-[#ffff] md:max-w-[497px]"></div>
                </div>

                <div className="mt-3 flex flex-wrap items-center gap-2">
                  <Image src={dcci} alt=""/>
                  <Image src={ispab} alt=""/>
                  <Image src={wba} alt=""/>
                  <Image src={basis} alt=""/>
                </div>
              </div>
            </div>
          </div>

          <div class="flex w-full items-center justify-center lg:w-1/2">
            <Image
              className="h-full w-full max-w-2xl rounded-md object-cover"
              src={achievement}
              alt="glasses photo"
            />
          </div>
        </div>
      </Container>
    </section>
  );
};
export default Achievement;
