"use client";
import React, { useEffect, useState } from "react";
import "./testimonial.scss";
import Image from "next/image";
import left from "../../images/leftg.png";
import right from "../../images/rightg.png";
import quote from "../../images/quote.png";
import Container from "../Container";

const TestimonialsSlider = () => {
  const cards = [
    {
      quote:
        "Our sincere gratitude for the exemplary data connectivity services",
      details: `
        Your commitment to delivering high-quality connectivity solutions 
        has significantly contributed to our operations’ efficiency and reliability. 
        We have been particularly impressed by the following aspects of your service:
        - Consistent Uptime
        - Responsive Support
        - Security Standards`,
      author: "Janata Bank Limited",
    },
    {
      quote: "We appreciate your positive approach .............",
      details: `
        Currently, we have ADN connectivity in our 468 branches. 
        Most of them are running very fine. We are delighted to have your service. 
        I wish you the best of success.`,
      author: "Sonali Bank PLC, Head Office",
    },
    {
      quote: "Outstanding customer service and reliable data solutions.",
      details: `ADN has been our go-to partner for secure connectivity. Their team's 
        commitment to resolving issues in real-time has been impressive.`,
      author: "Agrani Bank",
    },
  ];

  const [currentIndex, setCurrentIndex] = useState(0);
  const [cardsPerPage, setCardsPerPage] = useState(1); // Default to 1 card per page for small screens

  // Adjust the number of cards per page based on the window size
  useEffect(() => {
    const handleResize = () => {
      setCardsPerPage(window.innerWidth >= 1024 ? 2 : 1); // 2 cards on large screens, 1 card on smaller screens
    };
    handleResize(); // Set initially based on screen size
    window.addEventListener("resize", handleResize); // Adjust on window resize
    return () => window.removeEventListener("resize", handleResize);
  }, []);

  // Autoplay functionality
  useEffect(() => {
    const interval = setInterval(() => {
      nextSlide();
    }, 5000); // Change slide every 5 seconds

    return () => clearInterval(interval); // Clear interval on component unmount
  }, [currentIndex]); // Restart interval whenever currentIndex changes

  const totalCards = cards.length;

  const nextSlide = () => {
    setCurrentIndex((prevIndex) =>
      prevIndex === totalCards - 1 ? 0 : prevIndex + 1
    );
  };

  const prevSlide = () => {
    setCurrentIndex((prevIndex) =>
      prevIndex === 0 ? totalCards - 1 : prevIndex - 1
    );
  };

  // Get the cards to display, including wrapping logic
  const getDisplayedCards = () => {
    const displayedCards = [];
    for (let i = 0; i < cardsPerPage; i++) {
      const cardIndex = (currentIndex + i) % totalCards; // Ensures it wraps around when reaching the end
      displayedCards.push(cards[cardIndex]);
    }
    return displayedCards;
  };

  return (
    <section className="bg-darkgreen py-16 text-white marginTop">
      <Container>
        <h2 className="text-center text-[50px] font-bold">
          SOME OF THE <span className="text-green-400">TESTIMONY</span>
        </h2>
        <p className="mb-16 mt-2 text-center text-[32px]">Success Shines Bright</p>

        <div className="relative">
          <div className="mx-auto flex w-full max-w-[100%] flex-col gap-12">
            {/* Current slide (currentIndex) */}
            <div className="grid grid-cols-1 gap-6 pb-10 transition-transform duration-500 ease-in-out lg:grid-cols-2">
              {getDisplayedCards().map((card, index) => (
                <div key={index} className="testimonial-card flex w-full flex-col justify-between rounded-md bg-white p-8 text-black shadow-lg">
                  <div className="card-content">
                    <div className="flex justify-end -mt-16">
                      <Image src={quote} alt="" className="img" />
                    </div>
                    <p className="min-h-[60px] text-[32px] font-bold leading-10">
                      {`"${card.quote}"`}
                    </p>
                    <p className="mt-4 min-h-[180px] whitespace-pre-line text-[16px] font-medium leading-7">
                      {card.details}
                    </p>
                  </div>
                  <p className="mt-4 min-h-[40px] font-bold">{card.author}</p>
                </div>
              ))}
            </div>
          </div>

          {/* Arrows */}
          <button
            onClick={prevSlide}
            className="absolute left-[-10px] lg:left-[-40px] top-1/2 -translate-y-1/2 transform rounded-full p-1 text-[#3EC088]"
          >
            <Image src={left} alt="Previous Slide" />
          </button>
          <button
            onClick={nextSlide}
            className="absolute right-[-10px] lg:right-[-40px] top-1/2 -translate-y-1/2 transform rounded-full p-1 text-[#3EC088]"
          >
            <Image src={right} alt="Next Slide" />
          </button>
        </div>
      </Container>
    </section>
  );
};

export default TestimonialsSlider;
