"use client";
import React, { useEffect, useState } from "react";
import "./testimonial.scss";
import Image from "next/image";
import left from "../../images/leftg.png";
import right from "../../images/rightg.png";
import quote from "../../images/quote.png";
import Container from "../Container";

const Testimonials = () => {
  const cards = [
    {
      quote:
        "Our sincere gratitude for the exemplary data connectivity services",
      details: `
        Your commitment to delivering high-quality connectivity solutions 
        has significantly contributed to our operations’ efficiency and reliability. 
        We have been particularly impressed by the following aspects of your service:
        - Consistent Uptime
        - Responsive Support
        - Security Standards`,
      author: "Janata Bank Limited",
    },
    {
      quote: "We appreciate your positive approach .............",
      details: `
        Currently, we have ADN connectivity in our 468 branches. 
        Most of them are running very fine. We are delighted to have your service. 
        I wish you the best of success.`,
      author: "Sonali Bank PLC, Head Office",
    },
    {
      quote: "Outstanding customer service and reliable data solutions.",
      details: `ADN has been our go-to partner for secure connectivity. Their team's 
        commitment to resolving issues in real-time has been impressive.`,
      author: "Agrani Bank",
    },
  ];

  return (
    <section className="bg-darkgreen marginTop py-16 text-white">
      <Container>
        <h2 className="text-center text-[50px] font-bold">
          SOME OF THE <span className="text-green-400">TESTIMONY</span>
        </h2>
        <p className="mb-16 mt-2 text-center text-[32px]">
          Success Shines Bright
        </p>

        <div className="relative">
          <div className="mx-auto flex w-full max-w-[100%] flex-col gap-12">
            {/* Current slide (currentIndex) */}
            <div className="grid grid-cols-1 gap-6 pb-10 transition-transform duration-500 ease-in-out lg:grid-cols-2 gap-y-16">
              {cards.map((card, index) => (
                <div
                  key={index}
                  className="testimonial-card flex w-full flex-col justify-between rounded-md bg-white p-8 text-black shadow-lg "
                >
                  <div className="card-content">
                    <div className="-mt-16 flex justify-end">
                      <Image src={quote} alt="" className="img" />
                    </div>
                    <p className="min-h-[60px] text-[32px] font-bold leading-10">
                      {`"${card.quote}"`}
                    </p>
                    <p className="mt-4 min-h-[180px] whitespace-pre-line text-[16px] font-medium leading-7">
                      {card.details}
                    </p>
                  </div>
                  <p className="mt-4 min-h-[40px] font-bold">{card.author}</p>
                </div>
              ))}
            </div>
          </div>
        </div>
      </Container>
    </section>
  );
};

export default Testimonials;
