"use client";
import React from "react";

const StyledText = ({ text }) => {
  const words = text.split(" ");

  const getStyledText = () => {
    if (words.length > 2) {
      return (
        <>
          <span className="text-primary-light">{words[0].toUpperCase()} </span>
          <span className="text-primary-light">{words[1].toUpperCase()} </span>
          {words.slice(2).join(" ")} {/* Display the rest of the words without styling */}
        </>
      );
    } else if (words.length === 2) {
      return (
        <>
          <span className="text-primary-light">{words[0].toUpperCase()} </span>
          {words[1]}
        </>
      );
    } else if (words.length === 1) {
      return <span className="text-primary-light">{words[0].toUpperCase()}</span>;
    }
    return text; 
  };

  return <div>{getStyledText()}</div>;
};

export default StyledText;
