"use client";
import banner1 from "../../images/banner1.png"


import Image from "next/image";
import React, { useState } from 'react';
import styles from './slider.scss';
import { FaArrowLeft, FaArrowRight } from 'react-icons/fa'; // For navigation arrows
import left from "../../images/left.png";
import right from "../../images/right.png";

const SliderComponent = () => {
  const [currentSlide, setCurrentSlide] = useState(0);

  const slides = [
    {
      img: banner1, // Image for "BEYOND"
    },
    {
      img: '/assets/images/partners-banner.png', // Image for "LIMITS"
    },
    // {
    //   img: '/images/beyond2.png', // Image for "BEYOND" again or a different representation
    // },
    // {
    //   img: '/images/borders.png', // Image for "BORDERS"
    // },
  ];

  const nextSlide = () => {
    setCurrentSlide((prevSlide) => (prevSlide + 1) % slides.length);
  };

  const prevSlide = () => {
    setCurrentSlide((prevSlide) =>
      prevSlide === 0 ? slides.length - 1 : prevSlide - 1
    );
  };

  return (
    <div className="relative overflow-hidden bg-gradient-to-r from-green-400 to-blue-500">
      <div className="flex justify-center h-full">
        <div className={`transition-transform duration-700 aspect-video lg:aspect-auto lg:h-[80vh]`}>
          <Image
            src={slides[currentSlide].img}
            alt="Slider Image"
            height={3000}
            width={3000}
            className="rounded-lg object-fill lg:object-cover aspect-video lg:aspect-auto lg:h-[80vh] object-center"

          />
        </div>
      </div>
      <div className="absolute lg:bottom-10 bottom-1 left-[12%] transform -translate-x-1/2">
        <button onClick={prevSlide} className="text-white rounded-full">
            <Image src={left} alt="Slider Image"/>
        </button>
        <button onClick={nextSlide} className="text-white rounded-full">
            <Image src={right} alt="Slider Image"/>
        </button>
      </div>
    </div>
  );
};

export default SliderComponent;
