"use client";
import React from "react";
import "./servicecard.scss";
import Image from "next/image";
import icon1 from "../../images/icon1.png";
import icon2 from "../../images/icon2.png";
import rightarrow from "../../images/Group.png";
import Container from "../Container";
import HeaderSubHead from "../HeaderSubHead";

const ServiceCard = () => {
  let data = {
    title: "Services",
    description: "Our services suit your every business need",
  };

  const cards = [
    {
      image: icon1,
      title: "Seamless Connections For A Limitless World",
      listItems: [
        "Internet Service",
        "Data Service (IP/VPN)",
        "MPLS",
        "IPLC",
        "Internal LAN Connectivity",
        "VSAT Connectivity",
      ],
      footer: "CONNECTIVITY",
    },
    {
      image: icon2,
      title: "The Heartbeat of Your Digital World",
      listItems: [
        "Hosting Service",
        "Co-location Service",
        "Domain Registration",
        "Mail Hosting",
        "Website Hosting",
        "Public Cloud Service",
      ],
      footer: "DATA CENTER",
    },
    {
      image: icon1,
      title: "Data Secured, Future Assured",
      listItems: [
        "Surveillance Solution",
        "Access Control",
        "Anti-Money Laundering solution",
        "Drone Solutions",
        "Cloud Hosting",
        "Edge Computing",
      ],
      footer: "SECURITY",
    },
    {
      image: icon2,
      title: "Talk Smarter, Connect Faster",
      listItems: [
        "IP PBX Solution",
        "Call Center Solution",
        "SMS Service (A2P, P2A)",
        "Dynamic IVR System",
        "Voice Broadcast System",
        "Edge Computing",
      ],
      footer: "IP TELEPHONY",
    },
    {
      image: icon1,
      title: "New Smart Solutions",
      listItems: [
        "AI Integration",
        "Smart Security Systems",
        "Cloud Hosting",
        "Edge Computing",
      ],
      footer: "SMART SOLUTIONS",
    },
    {
      image: icon2,
      title: "New Smart Solutions",
      listItems: [
        "AI Integration",
        "Smart Security Systems",
        "Cloud Hosting",
        "Edge Computing",
      ],
      footer: "SMART SOLUTIONS",
    },
  ];

  return (
    <>
      <div id="service" className="marginTop">
        <Container>
          <HeaderSubHead data={data} />

          <section className="from-darkgreen to-lightgreen bg-gradient-to-b py-10">
            <div className="w-full">
              <div className="lg:ml-1/3 relative flex w-full flex-col items-center justify-center">
                <div className="grid w-full grid-cols-1 gap-6 px-8 sm:grid-cols-2 lg:grid-cols-3">
                  {cards.map((card, index) => (
                    <div
                      key={index}
                      className="rounded-lg shadow-lg transition-all duration-300 hover:scale-105"
                    >
                      <div className="flex h-[100px] items-center gap-3 bgGradient p-6">
                        <Image src={card.image} alt={card.title} />
                        <h3 className="w-[390px] text-2xl font-bold italic text-white">
                          {card.title}
                        </h3>
                      </div>

                      <div className="card">
                        <div className="list">
                          <ul className="space-y-2 p-6 text-white">
                            {card.listItems.map((item, idx) => (
                              <div
                                key={idx}
                                className="flex items-center gap-2"
                              >
                                <Image
                                  src={rightarrow}
                                  alt={item}
                                  className=""
                                />
                                <li key={idx}>{item}</li>
                              </div>
                            ))}
                          </ul>
                        </div>

                        <h4 className="cardFooter mt-3 p-6 text-center">
                          {card.footer}
                        </h4>
                      </div>
                    </div>
                  ))}
                </div>
              </div>
            </div>
          </section>
        </Container>
      </div>
    </>
  );
};

export default ServiceCard;
