"use client";
import React, { useState, useEffect } from "react";
import "./service.scss";
import radarImage from "../../images/service.png";
import Image from "next/image";
import icon1 from "../../images/icon1.png";
import icon2 from "../../images/icon2.png";
import rightarrow from "../../images/Group.png";
import uparrow from "../../images/seemore.png";
import Link from "next/link";
import Container from "../Container";
import HeaderSubHead from "../HeaderSubHead";

const Service = () => {
  let data = {
    title: "Services",
    description: "Our services suit your every business need",
  };

  const [currentSlide, setCurrentSlide] = useState(0);
  const [cardsPerPage, setCardsPerPage] = useState(4);

  // Adjust cards per page based on screen size
  const updateCardsPerPage = () => {
    const screenWidth = window.innerWidth;
    if (screenWidth < 640) {
      setCardsPerPage(1); // On small screens show 1 card per slide
    } else if (screenWidth < 1024) {
      setCardsPerPage(2); // On medium screens show 2 cards per slide
    } else {
      setCardsPerPage(4); // On large screens show 4 cards per slide
    }
  };

  useEffect(() => {
    // Set the initial cardsPerPage on component mount
    updateCardsPerPage();
    // Update cardsPerPage on window resize
    window.addEventListener("resize", updateCardsPerPage);
    return () => {
      window.removeEventListener("resize", updateCardsPerPage);
    };
  }, []);

  const cards = [
    {
      image: icon1,
      title: "Seamless Connections For A Limitless World",
      listItems: [
        "Internet Service",
        "Data Service (IP/VPN)",
        "MPLS",
        "IPLC",
        "Internal LAN Connectivity",
        "VSAT Connectivity",
      ],
      footer: "CONNECTIVITY",
    },
    {
      image: icon2,
      title: "The Heartbeat of Your Digital World",
      listItems: [
        "Hosting Service",
        "Co-location Service",
        "Domain Registration",
        "Mail Hosting",
        "Website Hosting",
        "Public Cloud Service",
      ],
      footer: "DATA CENTER",
    },
    {
      image: icon1,
      title: "Data Secured, Future Assured",
      listItems: [
        "Surveillance Solution",
        "Access Control",
        "Anti-Money Laundering solution",
        "Drone Solutions",
        "Cloud Hosting",
        "Edge Computing",
      ],
      footer: "SECURITY",
    },
    {
      image: icon2,
      title: "Talk Smarter, Connect Faster",
      listItems: [
        "IP PBX Solution",
        "Call Center Solution",
        "SMS Service (A2P, P2A)",
        "Dynamic IVR System",
        "Voice Broadcast System",
        "Edge Computing",
      ],
      footer: "IP TELEPHONY",
    },
    {
      image: icon1,
      title: "New Smart Solutions",
      listItems: [
        "AI Integration",
        "Smart Security Systems",
        "Cloud Hosting",
        "Edge Computing",
      ],
      footer: "SMART SOLUTIONS",
    },
    {
      image: icon2,
      title: "New Smart Solutions",
      listItems: [
        "AI Integration",
        "Smart Security Systems",
        "Cloud Hosting",
        "Edge Computing",
      ],
      footer: "SMART SOLUTIONS",
    },
    {
      image: icon1,
      title: "New Smart Solutions",
      listItems: [
        "AI Integration",
        "Smart Security Systems",
        "Cloud Hosting",
        "Edge Computing",
      ],
      footer: "SMART SOLUTIONS",
    },
  ];

  const totalSlides = Math.ceil(cards.length / cardsPerPage);

  // Auto-slide functionality
  useEffect(() => {
    const interval = setInterval(() => {
      nextSlide();
    }, 5000); // Change slide every 5 seconds

    return () => clearInterval(interval);
  }, [currentSlide]);

  // Slide navigation logic
  const nextSlide = () => {
    setCurrentSlide((prev) => (prev === totalSlides - 1 ? 0 : prev + 1));
  };

  const prevSlide = () => {
    setCurrentSlide((prev) => (prev === 0 ? totalSlides - 1 : prev - 1));
  };

  // Dot navigation logic
  const goToSlide = (slideIndex) => {
    setCurrentSlide(slideIndex);
  };

  // Calculate which cards to display based on currentSlide
  const displayedCards = cards.slice(
    currentSlide * cardsPerPage,
    currentSlide * cardsPerPage + cardsPerPage,
  );

  return (
    <>
      <div id="service" className="marginTop">
        <Container>
          <HeaderSubHead data={data} />

          <section className="from-darkgreen to-lightgreen bg-gradient-to-b py-10">
            <div className="container mx-auto flex flex-col items-start gap-8 px-5 lg:flex-row">
              <div className="flex w-full items-center justify-center lg:w-1/3">
                <Image
                  src={radarImage}
                  alt="Radar"
                  className="h-auto max-w-full"
                />
              </div>

              <div className="w-full lg:w-2/3">
                <div className="lg:ml-1/3 relative flex w-full flex-col items-center justify-center">
                  <div className="grid w-full grid-cols-1 gap-6 px-8 sm:grid-cols-2 lg:grid-cols-2">
                    {displayedCards.map((card, index) => (
                      <div
                        key={index}
                        className="rounded-lg shadow-lg transition-all duration-300 hover:scale-105"
                      >
                        <div className="bgGradient flex h-[100px] items-center gap-3 p-6">
                          <Image src={card.image} alt={card.title} />
                          <h3 className="w-[390px] text-2xl font-bold italic text-white">
                            {card.title}
                          </h3>
                        </div>

                        <div className="card">
                          <div className="list">
                            <ul className="space-y-2 p-6 text-white">
                              {card.listItems.map((item, idx) => (
                                <div
                                  key={idx}
                                  className="flex items-center gap-2"
                                >
                                  <Image
                                    src={rightarrow}
                                    alt={item}
                                    className=""
                                  />
                                  <li key={idx}>{item}</li>
                                </div>
                              ))}
                            </ul>
                          </div>

                          <h4 className="cardFooter mt-3 p-6 text-center">
                            {card.footer}
                          </h4>
                        </div>
                      </div>
                    ))}
                  </div>
                </div>

                {/* Dots navigation */}
                <div className="mt-5 flex items-center justify-center space-x-2">
                  {Array(totalSlides)
                    .fill()
                    .map((_, index) => (
                      <div
                        key={index}
                        onClick={() => goToSlide(index)}
                        className={`h-3 w-3 rounded-full ${
                          currentSlide === index
                            ? "bg-green-500"
                            : "bg-gray-300"
                        } cursor-pointer`}
                      />
                    ))}
                </div>

                <div className="flex items-center justify-end pt-5">
                  <p className="font-semibold text-[#30E496]">Learn More</p>
                  <Link href="/services">
                    <Image src={uparrow} alt="" />
                  </Link>
                </div>
              </div>
            </div>
          </section>
        </Container>
      </div>
    </>
  );
};

export default Service;
