import Image from "next/image";

const partners = [
  {
    image: '/assets/images/singtel.png',
    name: 'Singapore Telecommunications Limited'
  },
  {
    image: '/assets/images/sri-lanka-telecom.png',
    name: 'Sri Lanka Telecom PLC (SLT)'
  },
  {
    image: '/assets/images/airtel.png',
    name: 'Airtel Bangladesh'
  },
  {
    image: '/assets/images/orange.png',
    name: 'Orange S.A.'
  },
  {
    image: '/assets/images/bt.png',
    name: 'BT Group plc (trading as BT)'
  },
  {
    image: '/assets/images/tata-communication.png',
    name: 'Tata Communications'
  },
]

export function PartnersLogo() {
  return <section id="partners-logo" className="max-w-4xl flex bg-[#E7E7E7] my-8 lg:my-32 justify-evenly mx-auto  py-4 px-3 md:py-8 md:px-6 lg:py-16 lg:px-12 gap-4">
    {partners.map((p, i) => <div key={i} className="flex-grow ">
        <Image  src={p.image} alt={p.name} className="w-full max-w-28 aspect-square" width="200" height="200" />
      </div>
    )}
  </section>
}
