import Container from "@/app/component/Container";
import Image from "next/image";
import { ImageCard2 } from "@/app/component/ImageCard2";

const partners = [
  {
    image: '/assets/images/singtel.png',
    description: 'Singapore Telecommunications Limited (commonly abbreviated as Singtel, and previously stylised as SingTel) is a Singaporean telecommunications company. The company is the largest mobile network operators in Singapore with 4.1 million subscribers and through subsidiaries, has a combined mobile subscriber base of 640 million customers at the end of financial year 2017. The company was known as Telecommunications Equipment until 1995. Singtel provides ISP (SingNet), IPTV (Singtel TV) and mobile phone networks (Singtel Mobile) and fixed line telephony services.'
  },
  {
    image: '/assets/images/sri-lanka-telecom.png',
    description: 'Sri Lanka Telecom PLC (SLT)  is a telecommunications services provider in Sri Lanka and one of the country\'s largest companies(verification needed) with an annual turnover in excess of Rs 40 billion. The company provides domestic and corporate services which include fixed and wireless telephony, Internet access and IT services to domestic, public and business sector customers.'
  },
  {
    image: '/assets/images/airtel.png',
    description: 'Airtel Bangladesh is currently an independent product brand of Robi Axiata, since Robi Axiata Limited is the Licensee of ‘airtel’ Brand in Bangladesh. The brand came under the control of Robi Axiata after Airtel Bangladesh Limited was successfully merged into Robi Axiata Limited on 16 November 2016. Robi Axiata Limited is a joint venture between Axiata Group of Malaysia, Bharti Airtel of India and NTT Docomo Inc. of Japan. Axiata holds 68.7% controlling stake in the entity, Bharti holds 25% while the remaining 6.3% is held by NTT Docomo of Japan.'
  },
  {
    image: '/assets/images/orange.png',
    description: 'Orange S.A., formerly France Télécom S.A., is a French multinational telecommunications corporation. In 2015, the group had revenue of €40 billion. The company’s head office is located in the 15th arrondissement of Paris. Orange has been the company’s main brand for mobile, landline, internet and IPTV services since 2006. It originated in 1994 when Hutchison Whampoa acquired a controlling stake in Microtel Communications during the early 1990s and rebranded it as “Orange”. The company was rebranded as Orange in July 2013.'
  },
  {
    image: '/assets/images/bt.png',
    description: 'BT Group plc (trading as BT) is a holding company which owns British Telecommunications plc, a British multinational telecommunications company with head offices in London, United Kingdom. It has operations in around 180 countries and is the largest provider of fixed-line, mobile and broadband services in the UK, and also provides subscription television and IT services. BT’s origins date back to the founding of the Electric Telegraph Company in 1846 which developed a nationwide communications network. In 1912, the General Post Office, a government department, became the monopoly telecoms supplier in the United Kingdom.'
  },
  {
    image: '/assets/images/tata-communication.png',
    description: 'Tata Communications formerly called VSNL is a global provider of telecommunications solutions and services. It is part of the Tata Group. Tata Communications uses its network to deliver network services and software-defined network platforms, such as Ethernet, SD-WAN, Content delivery network (CDN), Internet, Multiprotocol Label Switching (MPLS) and Private Line. It has more than 400 Points of Presence (POP) globally with data centre and colocation in 44 sites.'
  },
]

export function Partners() {
  return <Container>
    <section id="#partners" className="mx-5 md:mx-10 2xl:mx-0">
      <h1 className="text-h1">Partners</h1>
      <p className="text-h2 lg:-mt-8">
        <span className="text-primary">Strategic</span> alliances
      </p>
      <p className="text-body-large text-justify my-7 lg:my-14"> ADN Telecom is a trusted partner in navigating the ever-evolving landscape of Information and Telecommunication technology. It is the flagship company of ADN Group which is one of the leading IT and Telecommunication service providers in Bangladesh offering a wide range of data, voice, and internet services to its local and international clients. </p>
      <Image src="/assets/images/partners-banner.png" className="w-full min-h-[500px] object-cover" alt="" width="1263" height="441" />

      <div className="space-y-8 my-12 2xl:my-24">
        {partners.map((p, i) => <ImageCard2 {...p} key="i"/>)}
      </div>
    </section>
  </Container>
}
