// "use client";

// import { useState } from "react";
// import "./_navbar.scss";
// import Image from "next/image";
// import logo from "../../images/adnlogo.svg";
// import burgerMenu from "../../images/Ellipse.png";
// import Drawer, { RightDrawer } from "../Drawer";
// import Link from "next/link";

// const Navbar = () => {
//   const [menuState, setMenuState] = useState(false);
//   const [isOpen, setIsOpen] = useState(false);
//   const [isSubMenuOpen, setIsSubMenuOpen] = useState(false); // New state for submenu

//   const handleClose = () => setIsOpen(false);

//   const navigation = [
//     {
//       title: "About",
//       path: "/about",
//       subMenu: [
//         { title: "Projects", path: "/projects" },
//         { title: "Core Management", path: "/management" },
//         { title: "Introduction", path: "/introduction" },
//       ],
//     },
//     { title: "Our Service", path: "/services" },
//     { title: "Investor information", path: "/investor" },
//     { title: "Licenses", path: "/licenses" },
//     { title: "Partners And Affiliates", path: "/partners" },
//     { title: "Contact Us", path: "javascript:void(0)" },
//   ];

//   return (
//     <div id="navbar">
//       <nav className="">
//         <div className="mx-auto flex max-w-screen-2xl shrink-0 items-center justify-between space-x-8 px-4 py-3 md:px-8">
//           <div className="flex-none shrink-0 lg:flex-initial">
//             <Link href="/">
//               <Image src={logo} width={120} height={50} alt="Float UI logo" />
//             </Link>
//           </div>
//           <div className="flex shrink-0 items-center">
//             <div>
//               <ul className="mt-12 hidden space-y-5 text-white lg:mt-0 lg:flex lg:space-x-6 lg:space-y-0">
//                 {navigation.map((item, idx) => (
//                   <li
//                     key={idx}
//                     className="relative text-[16px] font-bold"
//                     onMouseEnter={() => item.subMenu && setIsSubMenuOpen(true)}
//                     onMouseLeave={() => item.subMenu && setIsSubMenuOpen(false)}
//                   >
//                     {/* Main Menu Item */}
//                     <Link href={item.path}>{item.title}</Link>

//                     {/* SubMenu */}
//                     {item.subMenu && isSubMenuOpen && (
//                       <ul className="absolute left-0 mt-2 w-48 bg-[#034D57] p-3 rounded-lg shadow-lg">
//                         {item.subMenu.map((subItem, subIdx) => (
//                           <li key={subIdx} className="py-2 hover:text-[#30E496]">
//                             <Link href={subItem.path}>{subItem.title}</Link>
//                           </li>
//                         ))}
//                       </ul>
//                     )}
//                   </li>
//                 ))}
//               </ul>
//             </div>
//             <div className="hidden shrink-0 items-center space-x-2 pl-[48px] sm:space-x-6 lg:flex">
//               <form className="flex items-center space-x-2 rounded-full border px-3 py-2">
//                 <svg
//                   xmlns="http://www.w3.org/2000/svg"
//                   className="h-5 w-5 flex-none text-gray-300"
//                   fill="none"
//                   viewBox="0 0 24 24"
//                   stroke="currentColor"
//                 >
//                   <path
//                     strokeLinecap="round"
//                     strokeLinejoin="round"
//                     strokeWidth={2}
//                     d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"
//                   />
//                 </svg>
//                 <input
//                   className="w-full border-none bg-[#034D57] text-white placeholder:text-white focus:outline-none focus:ring-0 sm:w-auto"
//                   type="text"
//                   placeholder="Search"
//                 />
//               </form>
//             </div>
//             <div className="pl-[48px]">
//               <RightDrawer
//                 setIsOpen={setIsOpen}
//                 isOpen={isOpen}
//                 handleClose={handleClose}
//                 data={navigation}
//               />
//             </div>

//             <button
//               className="block text-gray-400 outline-none"
//               onClick={() => setIsOpen(true)}
//             >
//               {menuState ? (
//                 <svg
//                   xmlns="http://www.w3.org/2000/svg"
//                   className="h-6 w-6"
//                   fill="none"
//                   viewBox="0 0 24 24"
//                   stroke="currentColor"
//                 >
//                   <path
//                     strokeLinecap="round"
//                     strokeLinejoin="round"
//                     strokeWidth={2}
//                     d="M6 18L18 6M6 6l12 12"
//                   />
//                 </svg>
//               ) : (
//                 <svg
//                   xmlns="http://www.w3.org/2000/svg"
//                   className="h-6 w-6"
//                   fill="none"
//                   viewBox="0 0 24 24"
//                   stroke="currentColor"
//                 >
//                   <path
//                     strokeLinecap="round"
//                     strokeLinejoin="round"
//                     strokeWidth={2}
//                     d="M4 6h16M4 12h16m-7 6h7"
//                   />
//                 </svg>
//               )}
//             </button>
//           </div>
//         </div>
//       </nav>
//     </div>
//   );
// };

// export default Navbar;

"use client";

import { useState } from "react";
import "./_navbar.scss";
import Image from "next/image";
import logo from "../../images/adnlogo.svg";
import Drawer, { RightDrawer } from "../Drawer";
import Link from "next/link";

const Navbar = () => {
  const [menuState, setMenuState] = useState(false);
  const [isOpen, setIsOpen] = useState(false);
  const [openSubMenuIdx, setOpenSubMenuIdx] = useState(null); // Track submenu open state
  const [openNestedSubMenuIdx, setOpenNestedSubMenuIdx] = useState(null); // Track nested submenu

  const handleClose = () => setIsOpen(false);

  const navigation = [
    {
      title: "About",
      path: "/about",
      subMenu: [
        { title: "Projects", path: "/projects" },
        { title: "Core Management", path: "/management" },
        { title: "Introduction", path: "/introduction" },
      ],
    },
    { title: "Our Service", path: "/services" },
    { title: "Investor information", path: "/investor" },
    { title: "Licenses", path: "/licenses" },
    { title: "Partners And Affiliates", path: "/partners" },
    { title: "Contact Us", path: "javascript:void(0)" },
  ];

  const handleSubMenuToggle = (idx) => {
    if (openSubMenuIdx === idx) {
      setOpenSubMenuIdx(null); // Close submenu if already open
    } else {
      setOpenSubMenuIdx(idx); // Open submenu
    }
  };

  const handleNestedSubMenuToggle = (subIdx) => {
    if (openNestedSubMenuIdx === subIdx) {
      setOpenNestedSubMenuIdx(null); // Close nested submenu if already open
    } else {
      setOpenNestedSubMenuIdx(subIdx); // Open nested submenu
    }
  };

  return (
    <div id="navbar">
      <nav className="">
        <div className="mx-auto flex max-w-screen-2xl shrink-0 items-center justify-between space-x-8 px-4 py-3 md:px-8">
          <div className="flex-none shrink-0 lg:flex-initial">
            <Link href="/">
              <Image src={logo} width={120} height={50} alt="Float UI logo" />
            </Link>
          </div>
          <div className="flex shrink-0 items-center">
            <div>
              <ul className="mt-12 hidden space-y-5 text-white lg:mt-0 lg:flex lg:space-x-6 lg:space-y-0">
                {navigation.map((item, idx) => (
                  <li
                    key={idx}
                    className="relative text-[16px] font-bold"
                    onMouseLeave={() => setOpenSubMenuIdx(null)}
                  >
                    {/* Main Menu Item */}
                    <div
                      className="flex items-center"
                      onClick={() => handleSubMenuToggle(idx)}
                    >
                      <Link href={item.path}>{item.title}</Link>
                      {item.subMenu && (
                        <span className="ml-2">
                          {openSubMenuIdx === idx ? (
                            <svg
                              xmlns="http://www.w3.org/2000/svg"
                              className="h-4 w-4"
                              fill="none"
                              viewBox="0 0 24 24"
                              stroke="currentColor"
                            >
                              <path
                                strokeLinecap="round"
                                strokeLinejoin="round"
                                strokeWidth={2}
                                d="M6 18L18 6"
                              />
                            </svg> // Up Arrow when submenu is open
                          ) : (
                            <svg
                              xmlns="http://www.w3.org/2000/svg"
                              className="h-4 w-4"
                              fill="none"
                              viewBox="0 0 24 24"
                              stroke="currentColor"
                            >
                              <path
                                strokeLinecap="round"
                                strokeLinejoin="round"
                                strokeWidth={2}
                                d="M6 6l12 12"
                              />
                            </svg> // Down Arrow when submenu is closed
                          )}
                        </span>
                      )}
                    </div>

                    {/* SubMenu */}
                    {item.subMenu && openSubMenuIdx === idx && (
                      <ul className="absolute left-0 mt-2 w-48 rounded-lg bg-[#034D57] p-3 shadow-lg">
                        {item.subMenu.map((subItem, subIdx) => (
                          <li
                            key={subIdx}
                            className="py-2 hover:text-[#30E496]"
                            onClick={() => handleNestedSubMenuToggle(subIdx)}
                          >
                            <div className="flex items-center">
                              <Link href={subItem.path}>{subItem.title}</Link>

                              {/* Check if subMenu exists in submenu */}
                              {subItem.subMenu && (
                                <span className="ml-2">
                                  {openNestedSubMenuIdx === subIdx ? (
                                    <svg
                                      xmlns="http://www.w3.org/2000/svg"
                                      className="h-4 w-4"
                                      fill="none"
                                      viewBox="0 0 24 24"
                                      stroke="currentColor"
                                    >
                                      <path
                                        strokeLinecap="round"
                                        strokeLinejoin="round"
                                        strokeWidth={2}
                                        d="M6 18L18 6"
                                      />
                                    </svg> // Up Arrow when nested submenu is open
                                  ) : (
                                    <svg
                                      xmlns="http://www.w3.org/2000/svg"
                                      className="h-4 w-4"
                                      fill="none"
                                      viewBox="0 0 24 24"
                                      stroke="currentColor"
                                    >
                                      <path
                                        strokeLinecap="round"
                                        strokeLinejoin="round"
                                        strokeWidth={2}
                                        d="M6 6l12 12"
                                      />
                                    </svg> // Down Arrow when nested submenu is closed
                                  )}
                                </span>
                              )}
                            </div>

                            {/* Nested SubMenu */}
                            {subItem.subMenu &&
                              openNestedSubMenuIdx === subIdx && (
                                <ul className="ml-4 mt-2 rounded-lg bg-[#045A64] p-2 shadow-lg">
                                  {subItem.subMenu.map(
                                    (nestedSubItem, nestedIdx) => (
                                      <li
                                        key={nestedIdx}
                                        className="py-1 hover:text-[#30E496]"
                                      >
                                        <Link href={nestedSubItem.path}>
                                          {nestedSubItem.title}
                                        </Link>
                                      </li>
                                    ),
                                  )}
                                </ul>
                              )}
                          </li>
                        ))}
                      </ul>
                    )}
                  </li>
                ))}
              </ul>
            </div>

            <div className="hidden shrink-0 items-center space-x-2 pl-[48px] sm:space-x-6 lg:flex">
              <form className="flex items-center space-x-2 rounded-full border px-3 py-2">
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  className="h-5 w-5 flex-none text-gray-300"
                  fill="none"
                  viewBox="0 0 24 24"
                  stroke="currentColor"
                >
                  <path
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    strokeWidth={2}
                    d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"
                  />
                </svg>
                <input
                  className="w-full border-none bg-[#034D57] text-white placeholder:text-white focus:outline-none focus:ring-0 sm:w-auto"
                  type="text"
                  placeholder="Search"
                />
              </form>
            </div>
            <div className="pl-[48px]">
              <RightDrawer
                setIsOpen={setIsOpen}
                isOpen={isOpen}
                handleClose={handleClose}
                data={navigation}
              />
            </div>

            <button
              className="block text-gray-400 outline-none"
              onClick={() => setIsOpen(true)}
            >
              {menuState ? (
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  className="h-6 w-6"
                  fill="none"
                  viewBox="0 0 24 24"
                  stroke="currentColor"
                >
                  <path
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    strokeWidth={2}
                    d="M6 18L18 6M6 6l12 12"
                  />
                </svg>
              ) : (
                <svg
                  xmlns="http://www.w3.org/2000/svg"
                  className="h-6 w-6"
                  fill="none"
                  viewBox="0 0 24 24"
                  stroke="currentColor"
                >
                  <path
                    strokeLinecap="round"
                    strokeLinejoin="round"
                    strokeWidth={2}
                    d="M4 6h16M4 12h16m-7 6h7"
                  />
                </svg>
              )}
            </button>
          </div>
        </div>
      </nav>
    </div>
  );
};

export default Navbar;
