"use client";

import React, { useState } from "react";
import "./map.scss";
import coverageAreaBg from "../../images/coverage-area-bg.svg";
import coverageShape2 from "../../images/coverage-shape2.svg";
import Image from "next/image";
import { Button, Modal } from "flowbite-react";
import MyGoogleMap from "@/app/helper/MyGoogleMap";
import popicon from "../../images/pop.svg";
import location from "../../images/location.svg";
import regional from "../../images/regional-hub.svg";

import highlightTitleInDescription from "@/app/helper/highlightTitleInDescription";

const Map = () => {
  const [openModal, setOpenModal] = useState(false);
  let data = {
    title: "Coverage",
    description: "Coverage Area",
  };
  return (
    <section
      className="coverage-area  lg:py-16"
      style={{ backgroundImage: `url(${coverageAreaBg.src})` }}
    >
      <div className="overlay"></div>
      <div className="shape1">
        <h1 className="text-h1">{data.title}</h1>
      </div>
      <div className="shape2">
        <Image
          className="shape-right-parallax"
          src={coverageShape2}
          alt="Background shape"
        />
      </div>
      <div className="container mx-auto">
        <div className="wrapper grid grid-cols-1 md:grid-cols-2">
          <div
            className="flex justify-center"
            data-wow-duration="1s"
            data-wow-delay=".6s"
          >
            <div>
              <svg
                // width="445"
                height="624"
                viewBox="0 0 445 624"
                fill="none"
                className="map w-full"
                xmlns="http://www.w3.org/2000/svg"
              >
                <g clip-path="url(#clip0_982_14494)">
                  <path
                    d="M440.418 544.932C439.525 534.041 437.739 519.639 438.215 506.963L440.001 499.167L438.691 493.811L436.668 486.253L436.429 480.719L434.644 476.493L434.763 473.815L435.12 469.173L434.882 460.068L434.644 455.605L434.227 450.487L431.132 447.571L430.894 439.358L430.477 432.038L428.453 430.729L428.691 428.051L430.239 426.503L430.477 423.409L429.346 422.1L429.108 412.578L426.906 410.554L425.358 409.662L423.81 409.007L423.394 405.674L423.156 402.58L419.287 396.152L414.941 389.666V376.692L412.263 372.348L411.37 358.779L413.81 355.03L414.465 352.828L413.81 349.912L412.917 344.794L412.025 343.246L411.608 339.676L409.406 339.259L409.167 337.712L407.858 329.499V325.928L406.31 322.358L404.108 320.156L404.763 315.692L405.179 310.158C405.179 310.158 402.501 306.171 400.953 308.849C399.406 311.527 400.06 313.729 400.06 313.729L399.406 314.859L397.62 314.621L397.382 312.062L397.144 308.67L395.12 306.885L392.917 306.647L389.167 308.849C389.167 308.849 385.834 313.729 383.81 314.383C381.787 315.038 380.06 314.383 380.06 314.383L376.965 312.003L374.763 309.027C374.763 309.027 372.322 305.278 372.084 307.48C371.846 309.682 372.322 316.347 372.322 316.347L373.215 321.465L374.525 326.821C374.525 326.821 374.763 331.701 373.394 333.248C372.084 334.796 371.191 336.819 365.417 338.783C359.644 342.77 358.989 346.103 358.989 346.103C358.989 346.103 355.655 354.078 355.655 355.208C355.655 356.339 355.894 360.743 356.965 363.183C358.096 365.623 360.953 370.741 359.882 372.705C358.81 374.669 356.786 375.145 356.786 377.823C356.786 380.501 357.025 382.286 355.001 382.465C352.977 382.703 346.548 383.357 345.001 385.797C343.453 388.237 342.977 390.261 341.667 390.261C340.358 390.261 338.334 386.273 338.334 386.273L335.655 385.857V383.655L334.108 379.013L332.56 377.466L331.905 373.895L330.774 370.8V368.598L329.465 365.92V362.826L327.917 361.517L327.024 358.838L324.822 358.422L323.929 355.982H320.834L318.632 358.66V362.409L318.215 366.873L320.001 371.991L320.417 375.978C320.417 375.978 318.394 379.073 314.644 372.645C312.858 367.289 312.858 364.671 312.858 364.671L312.62 360.683L311.965 355.803L310.834 352.054L310.417 349.852L310.655 347.829L312.679 346.282L308.453 344.258L307.56 340.687L307.798 337.117L305.774 334.201L301.132 331.106L301.786 327.535L297.798 320.453V315.811L300.893 315.157L301.31 312.122L298.393 310.277L295.715 309.86L295.477 305.635L300.834 305.397L302.858 303.195L305.298 298.732L304.882 292.066V287.96L306.191 282.247L309.286 280.045C309.286 280.045 313.751 279.39 314.822 279.39C315.953 279.39 317.024 276.712 317.024 276.712L318.572 273.618L317.917 268.5C317.917 268.5 318.572 265.584 321.905 266.952C325.239 268.262 331.251 269.392 331.251 269.392L336.37 269.63L341.013 267.845C341.013 267.845 342.322 264.75 342.798 261.18C343.215 257.609 344.346 252.967 345.894 257.192C347.441 261.418 348.989 262.965 348.989 262.965L353.215 262.548L353.632 258.561V254.574L356.965 254.157C356.965 254.157 356.727 255.943 358.096 255.943C359.406 255.943 360.536 256.359 361.191 257.966C361.846 259.573 364.108 261.299 364.108 261.299L365.239 262.608L367.441 262.37L367.679 259.454L368.096 254.99L370.536 254.574L369.644 250.825V244.397C369.644 244.397 371.667 242.612 373.394 244.159C375.179 245.707 375.417 244.576 375.417 242.612C375.417 240.589 373.87 238.863 373.87 238.863H386.251L389.346 235.53L388.691 223.747L394.227 219.283L394.882 213.511L396.013 208.631L398.691 202.858L400.894 197.978V191.967L398.453 187.325C398.453 187.325 399.346 182.862 403.096 183.993C406.846 185.124 408.632 185.778 408.632 185.778L410.834 187.325L416.37 187.742H419.941L421.727 185.302L421.965 180.66L418.632 177.089L415.715 175.959L414.822 170.186L410.596 168.401L406.608 166.853L405.715 164.413L397.501 164.175L396.846 160.605L391.31 159.057L386.429 155.963C386.429 155.963 377.739 154.415 376.429 154.415C375.12 154.415 374.882 155.725 374.882 155.725H372.441L369.763 154.594L364.644 154.356L364.405 156.379L358.87 156.617L353.751 156.855V154.832L351.548 158.165L349.346 157.51L347.322 159.295L344.644 160.605L339.763 159.712L337.739 155.963L333.096 158.879L326.429 158.641L319.763 157.331L313.572 157.093L307.382 152.213L303.81 153.999L288.691 153.582L281.786 156.498L278.87 156.915L272.441 158.224L267.977 158.641L264.227 158.224C264.227 158.224 262.203 155.784 259.762 156.022C257.322 156.26 255.774 158.462 253.334 158.462C250.893 158.462 249.762 155.546 245.536 156.022C241.31 156.439 243.334 157.153 238.631 156.915C233.989 156.677 233.989 156.677 229.941 158.046C225.953 159.355 221.489 158.938 219.703 156.915C217.917 154.891 214.167 153.166 208.155 152.928C202.143 152.69 196.131 150.726 192.381 147.155C188.631 143.584 178.81 142.275 176.369 142.513C173.929 142.751 169.286 145.429 170.357 135.61C170.596 133.289 170.953 130.789 171.31 128.29C172.441 120.256 173.869 112.162 174.346 109.603C175 106.27 169.881 101.39 169.881 96.2724C169.881 91.1543 166.548 89.607 169.227 84.7271C171.905 79.8471 174.107 75.2052 174.107 75.2052H170.536L171.846 72.5271L172.084 69.4325L168.512 69.6706L167.203 67.2306L165.417 64.7906L166.727 61.696L164.941 59.018L163.631 56.578L162.5 53.2453L156.488 52.1146V45.6873H151.846L152.084 49.02L153.869 49.6746L150.119 50.8053L147.441 52.5907L147.679 56.1614L149.703 56.9946L148.334 57.9467L148.988 60.1487L151.667 59.9106L152.798 62.8267L146.786 65.2667L146.548 69.492C146.548 69.492 144.524 73.0627 141.905 69.254L134.346 68.3613L132.143 66.814L130.595 66.576L128.81 67.8852H126.786L122.798 66.7545L119.881 64.0765L118.334 61.3984L117.203 59.4345L114.524 56.5185L110.953 56.1019L108.036 55.4472L106.905 51.698L106.667 46.818L105.536 43.7234L104.226 41.9381L103.334 39.022L102.024 34.7966L104.703 35.2132L104.941 31.8806L102.738 31.464L101.191 30.5713L100.298 27.8933L96.9645 27.0006L92.0835 24.3226L90.2978 21.8826L87.8573 22.5372L87.4406 24.7391L86.3097 26.9411L86.9645 30.5118L88.9883 30.9284L92.3216 32.9518L92.9764 37.4152L94.7621 37.1771L96.0716 40.5098L97.8573 41.819L96.5478 43.6044L95.893 44.9137H90.774C90.774 44.9137 88.0954 40.2717 85.4168 39.3791C82.7383 38.4864 80.9525 40.5098 79.643 42.2951C78.3335 44.0805 75.6549 42.5332 75.4168 40.2717C75.1787 38.0698 71.4287 37.8317 68.9882 37.8317C66.5478 37.8317 62.0835 41.4025 62.0835 39.3791C62.0835 37.3557 64.762 36.463 64.762 36.463L67.8573 34.261L67.6192 31.8211L66.9644 29.7977L65.4168 28.2503L62.9763 24.9177L61.8454 22.7157L59.643 20.9304L57.4406 18.4904L52.7977 18.907L50.5953 16.7051L48.393 14.2651L43.9287 11.1705L41.4882 10.2778H39.7025L38.5715 1.64856L34.7025 4.8622V11.23L32.8572 13.2534L31.012 16.467V18.7285H33.2739L36.4882 16.8836L41.4882 18.7285H43.512L46.2501 19.8592V26.703L48.0953 28.3099V29.9167H44.7025L42.2025 29.024L39.5834 31.9996V33.6064L36.2501 35.2132L34.2263 37.2366L31.9643 38.8434L32.4405 44.9732L31.0715 46.3419H28.3334L26.9643 47.4727H20.5358L18.9881 51.1029H16.7262V53.8404L15.1191 56.1019V59.3155L16.4881 62.5292L15.1191 64.7906H12.6191V69.7896L10.7738 71.813L8.03573 74.7886V79.371L9.40478 82.7632L9.64288 86.6314L11.4881 89.607C11.4881 89.607 12.381 90.0831 14.881 89.607C17.381 89.1309 19.4643 88.2383 19.4643 88.2383L23.75 87.4051L25.3572 89.9046L28.0953 92.6421C28.0953 92.6421 35.8334 98.5933 39.0477 102.224L39.5239 111.329H43.631L44.1072 113.828L48.2144 115.852V119.065L49.5834 120.672H58.0358V122.517H59.8811V124.124H64.4644V120.732L67.6787 120.077L69.9406 119.601L72.9168 119.839L76.3097 122.577L77.4406 125.314V128.528H75.8335L74.9406 131.92L77.4406 134.181V136.919L80.6549 139.418H82.9168L85.4168 141.442H93.6311V144.417L92.2621 145.786L89.7621 147.81L88.393 151.916L87.024 156.677H83.8097L80.4168 153.463L78.1549 152.571L75.6549 152.809L74.0478 155.308H68.8097L65.1787 152.094H54.5239C54.5239 152.094 53.1549 154.832 50.7739 154.594C48.393 154.356 43.8096 149.833 41.3096 151.618C38.8096 153.463 40.6548 158.7 40.6548 158.7L40.8929 167.389L37.262 170.603L36.131 174.233L34.2858 178.815L31.5477 182.207L28.5715 185.183H24.7024L21.4881 182.684L20.8334 179.47L17.6191 177.863L14.4048 178.994L11.0119 180.363L11.9048 183.755L12.5595 188.337L10.7143 190.361L7.97621 191.967L6.36906 195.836H4.34525V199.942L1.60715 203.453L0 205.715L1.36905 208.928L3.63096 210.773L5.89287 214.165L6.54763 221.009L8.39287 223.509L11.6072 225.532L19.1072 227.793L23.2143 228.924C23.2143 228.924 25.7143 229.817 26.4286 231.186C27.0834 232.554 34.1667 239.16 35.5358 239.636C36.9048 240.112 41.9048 242.374 41.9048 242.374L46.6668 245.111H56.7263C56.7263 245.111 61.3096 244.635 62.2025 246.718C63.0954 248.801 66.3097 251.063 64.9406 256.776L62.4406 259.751L61.7858 270.94L65.6549 272.308L66.3097 275.284L65.6549 277.129L64.762 278.498V284.627L64.5239 287.96H62.0239L59.5239 290.34L56.3096 291.709H52.4406L52.2025 297.422L50.3572 299.267L50.1192 302.481V305.456L48.7501 308.432L48.9882 312.776L48.512 315.99H51.1311L50.893 319.62H55.4763L56.3692 324.203L57.9763 326.702L60.9525 328.071L62.9763 329.678L64.8216 333.07C64.8216 333.07 68.9287 333.308 69.4049 330.57L70.0597 334.915L68.6906 336.045L66.4287 337.652V343.782L63.6906 346.282L61.6668 348.305L61.4287 356.279H65.7739L66.9049 358.124H71.4882C71.4882 358.124 74.7025 355.387 76.0716 356.756C77.4406 358.124 81.3097 359.969 81.3097 359.969H87.9168L87.4406 362.231L84.4645 364.968L77.6192 372.288L76.9644 386.869L81.0716 391.213V396.45H86.3097L85.8335 402.58L83.8097 408.055L83.5716 413.53L84.2264 421.504L85.3573 425.611L83.3335 429.955C83.3335 429.955 86.5478 433.347 87.2026 435.668C87.8573 437.93 87.8573 453.224 87.8573 453.224C87.8573 453.224 89.2264 453.462 89.2264 458.461L91.9645 464.412L95.1788 467.15L97.4407 472.863H98.5716L96.3097 474.887L94.2859 476.017L92.4407 479.409L93.3335 483.516L95.3573 486.491L94.4645 494.704L94.2264 498.81H95.3573L96.2502 505.178L98.5121 509.046L100.774 507.678L103.274 505.833V509.046L105.536 512.022L106.429 515.89V522.02H109.822C109.822 522.02 113.036 520.889 113.036 519.282V515.414L114.167 510.653L113.036 508.63L114.167 505.416L115.536 502.679L116.905 498.81L119.643 498.156V489.288L121.726 487.205C121.488 487.622 121.191 488.693 121.965 491.55C123.095 495.656 123.572 498.632 123.572 498.632V502.024L121.965 503.869L121.488 506.606C121.488 506.606 120.595 512.558 121.965 513.926C123.334 515.295 125.357 517.795 126.965 515.533C128.572 513.272 128.572 512.141 130.179 510.772V502.202L135.417 497.203V488.098L134.048 486.253L133.81 483.516L135.417 481.016V476.255L133.572 475.779H132.203L131.726 471.673L131.072 467.567L130.179 464.353L131.072 461.853L133.095 456.616C133.095 456.616 134.703 456.854 133.988 460.723C133.334 464.591 134.465 468.935 134.465 468.935C134.465 468.935 135.834 471.673 136.488 473.28C137.143 474.887 137.857 476.672 138.096 479.409C138.334 482.147 137.441 484.408 138.096 488.515C138.096 488.515 139.226 482.802 140.596 479.647C141.965 476.434 141.25 472.804 140.596 470.959C139.941 469.114 138.334 466.198 138.334 466.198L141.429 463.222V461.377L142.917 457.509L145.655 454.117L145.953 453.522L146.786 451.617V460.485L144.762 463.222L142.738 465.484L142.5 468.221L144.107 470.483L144.762 472.982L145 477.981L144.107 480.481L141.607 486.432L141.131 489.824L142.024 495.775L141.369 499.405L140 501.25L137.976 503.095L137.084 504.94L137.738 509.046L138.631 511.546V514.938L139.762 517.676L142.262 517.914H145.238L143.869 512.439C143.869 512.439 144.346 510.832 145.715 511.546C147.084 512.2 150.298 513.391 152.322 513.153L153.453 510.653L151.846 508.63L148.453 504.285L146.607 502.917V498.334L148.869 494.466C148.869 494.466 150.893 496.073 150.715 499.227C150.476 502.441 150.715 504.464 153.453 504.702C156.191 504.94 158.036 504.226 158.036 504.226C158.036 504.226 160.06 503.571 161.429 503.988C162.798 504.464 163.453 504.881 165.536 502.857C167.56 500.834 167.798 498.751 170.119 498.513C172.381 498.275 169.881 495.299 168.988 493.752C168.096 492.145 167.857 483.932 168.334 482.802C168.81 481.671 162.857 480.778 165.119 479.588C167.381 478.457 168.988 480.064 170.119 476.612C171.25 473.22 169.465 467.924 169.465 467.924L168.334 464.055L167.203 461.08L168.334 456.319L169.941 452.689L171.072 450.189V446.321C171.072 446.321 172.203 442.215 174.227 444.476C176.25 446.737 179.703 439.239 179.703 439.239C179.703 439.239 180.298 437.156 181.131 435.609C181.905 434.121 182.858 433.169 183.631 434.954C183.631 434.954 184.286 438.406 182.5 441.024C180.715 443.702 179.822 443.94 176.488 449.237C173.155 454.593 171.607 458.997 172.917 462.984L174.227 466.971L175.536 471.435L175.119 477.446V482.98C175.119 482.98 176.429 485.004 177.143 485.896C177.858 486.789 178.929 490.538 180.477 488.991C182.024 487.444 178.929 484.349 182.262 480.778C185.596 477.208 185.596 473.875 185.596 473.875L189.167 469.888L192.084 469.65V472.09L187.203 475.006V481.016L184.524 483.218L184.108 486.551L186.31 487.444H188.75L188.988 483.873L192.084 480.957L194.524 476.493L197.203 474.708L198.512 473.815L202.5 473.399L204.524 468.519L206.072 467.626V473.815L204.524 475.839L199.167 478.041L197.143 480.481L194.048 482.921L192.738 485.837L192.5 489.407L188.75 490.3L185.834 493.395L185.596 500.298C185.596 500.298 187.619 504.285 189.822 502.083C192.024 499.882 195.596 494.287 195.596 494.287C195.596 494.287 196.488 498.037 194.465 500.477C192.441 502.917 194.048 507.559 197.143 507.559C200.238 507.559 207.798 506.428 210.239 500.001C212.679 493.573 212.679 484.23 216.429 481.135C220.179 478.041 219.346 473.815 219.346 473.815C219.346 473.815 222.679 468.935 220.655 464.948C220.655 464.948 221.965 461.615 222.679 457.628C222.679 457.628 224.227 459.652 223.572 463.163C222.917 466.733 227.203 466.733 225.715 469.173C224.227 471.613 221.786 473.637 222.917 475.839C224.048 478.041 224.941 480.302 227.143 478.279C229.346 476.255 230.715 471.851 231.608 468.043C232.5 464.293 234.524 468.043 236.072 466.733C237.62 465.424 243.631 461.615 242.739 448.106C242.739 448.106 241.608 444.774 240.536 443.226C239.405 441.679 238.334 440.786 239.643 438.346C240.953 435.906 241.191 431.919 236.072 429.003C230.953 426.087 230.953 428.586 230.06 430.134C229.167 431.681 228.75 433.05 228.75 433.05L226.727 434.597L225.774 432.395L227.381 430.193L227.619 427.277L229.643 425.968L233.215 422.219L231.905 417.755L229.881 410.673H226.727L225.774 411.983L222.977 410.197L221.429 409.959L219.881 407.757L221.429 406.865L223.631 407.281L224.524 405.496L222.739 404.603L226.965 404.187L227.381 399.545L229.405 394.665L234.286 394.903L234.703 392.701L232.917 390.499L229.822 385.619L227.798 383.179V378.715L226.905 376.692V375.383L229.822 374.966L232.024 374.074L235.12 372.943L237.798 371.157L238.691 373.359L239.822 372.05L240.06 370.503L240.953 360.981L242.798 359.85L240.477 354.732L235.596 352.292L232.679 351.638L228.691 349.852L225.715 349.614L223.81 347.829L219.167 342.949L214.941 340.747L211.846 338.307L207.858 334.974L211.846 336.105L214.762 336.76L218.334 338.783H220.119L224.762 339.2H228.334L233.87 339.854L238.096 338.962L239.405 333.844L238.75 329.202V325.452L232.084 325.869L230.774 323.667L231.012 321.644L232.56 322.774C232.56 322.774 233.691 324.798 236.548 323.905C238.215 323.429 239.346 322.417 240 321.644L243.572 322.596L242.798 323.905L241.905 326.345V329.678L243.929 330.57L247.5 328.785L249.703 327L251.905 325.452L253.215 325.214L254.524 328.13V330.154C254.524 330.154 253.87 332.356 252.5 332.832C251.191 333.248 247.62 333.725 247.62 333.725L245.417 333.07L243.393 334.201L242.977 340.39V344.615L244.762 347.531L248.75 349.555V358.184L246.965 359.731L246.072 368.182L245.179 377.525L249.822 381.989C249.822 381.989 255.834 390.856 256.012 394.189C256.251 397.521 257.322 403.056 257.322 403.056C257.322 403.056 262.858 410.138 263.751 412.399C264.643 414.661 266.846 412.816 267.501 414.601C268.155 416.386 269.286 418.826 271.251 419.719C273.215 420.612 275.477 421.266 278.81 423.706C282.143 426.146 288.81 437.037 291.489 437.037C294.167 437.037 304.346 431.681 306.132 424.182C307.917 416.684 303.215 415.494 303.215 415.494C303.215 415.494 306.251 415.732 306.489 414.184C306.727 412.637 305.417 411.09 303.632 410.852C301.846 410.614 303.81 408.412 306.489 407.936C309.167 407.519 311.846 407.281 312.917 406.627C314.048 405.972 314.941 405.079 316.489 406.388C318.036 407.698 320.715 404.187 320.715 402.163C320.715 400.14 323.394 401.925 324.465 397.7C325.596 393.474 328.215 390.618 328.215 393.712C328.215 396.807 326.013 403.056 326.013 404.603C326.013 406.15 326.013 408.828 328.215 410.376C330.417 411.923 330.894 411.685 333.751 414.125C336.667 416.565 341.548 422.338 342.858 425.67C344.167 429.003 350.655 435.668 351.31 440.965C351.965 446.321 354.405 443.643 354.882 448.939C355.298 454.295 353.334 459.592 356.191 461.139C359.108 462.687 359.108 460.901 357.977 458.045L356.429 454.057L358.691 452.927L360.239 451.796L362.263 449.118L365.179 448.701V445.785L367.62 441.56L371.548 442.691L368.334 444.893L367.917 448.88V451.974L366.37 453.998V456.021L362.62 454.712H360.179C360.179 454.712 359.048 458.045 360.417 458.283C361.727 458.521 363.989 458.283 362.62 460.723C361.31 463.163 360.834 463.401 360.834 465.603C360.834 467.805 359.525 471.792 360.834 471.792C362.144 471.792 363.275 468.221 363.929 470.007C364.584 471.792 365.477 476.434 365.477 479.528C365.477 482.623 366.786 487.503 366.786 489.288C366.786 491.074 368.572 489.705 368.81 493.038C369.048 496.37 369.048 501.012 369.048 503.452C369.048 505.892 369.286 509.225 369.941 509.225C370.596 509.225 373.691 507.201 373.275 510.772C372.858 514.343 375.715 517.854 375.953 520.532C376.191 523.21 379.286 518.509 380.179 520.532C381.072 522.556 380.179 526.721 380.179 526.721L378.156 532.732C377.025 536.065 376.37 537.195 376.608 539.397C376.846 541.599 373.275 544.277 374.167 545.587C375.06 546.896 374.584 548.027 377.501 550.467C380.417 552.907 380.537 557.548 380.537 557.548C380.537 557.548 383.453 558.679 383.275 562.905C383.096 567.13 380.417 570.879 383.275 573.141C386.132 575.343 388.394 577.366 390.12 581.353C391.906 585.34 393.691 588.019 395.239 588.435C396.787 588.852 397.263 588.435 398.572 592.66C399.882 596.886 400.596 598.433 402.798 601.766C405.001 605.098 407.441 607.538 408.334 610.455C409.227 613.371 409.882 615.334 412.56 620.691C415.239 626.047 412.977 616.941 410.775 608.491C408.572 600.04 407.203 595.636 407.203 595.636V588.495L401.667 581.591L399.465 576.057V572.307L399.882 566.951V563.381L399.465 559.393L399.703 556.061L404.346 553.859L404.763 549.633L409.227 548.979L415.001 544.337H417.679L420.775 545.646V553.383L424.763 554.275H428.096L429.644 552.073L433.632 553.204L435.179 559.215L436.965 566.118L440.953 565.226C440.953 565.226 444.941 562.131 444.941 558.798C445.06 555.406 441.31 555.823 440.418 544.932V544.932ZM91.0121 501.964L92.3811 500.239V508.808L94.643 511.546L97.6192 514.283C97.6192 514.283 101.964 517.259 100.357 514.283C98.7502 511.308 96.1311 509.939 95.8335 509.701L94.4049 508.57L93.9288 500.358L94.1669 498.751L90.9526 498.513V501.964H91.0121ZM117.976 505.833L119.345 503.809L120.953 501.786V500.179L117.976 501.786V505.833ZM117.976 517.676V519.282L120.953 518.509L119.465 516.545L117.976 517.676V517.676ZM223.572 481.671L222.56 479.588H221.072L220.179 482.326L221.072 483.694L222.56 482.802L223.572 481.671V481.671ZM229.465 483.694H227.441L225.774 484.587L223.572 487.563L222.56 490.955L221.846 493.692L220.119 495.954V498.453C220.119 498.453 222.739 497.323 225.774 495.24C228.81 493.216 231.786 490.003 231.31 487.503C230.834 485.063 229.465 483.694 229.465 483.694V483.694ZM234.286 486.67C236.548 485.063 236.786 483.04 237.917 481.671C239.048 480.302 239.941 479.409 240.417 475.541C240.893 471.673 242.024 468.459 242.024 468.459C242.024 468.459 237.917 471.197 237.024 472.804C236.131 474.41 231.191 477.386 231.369 478.755C231.548 480.124 231.369 484.706 231.369 484.706C231.369 484.706 231.965 488.277 234.286 486.67ZM242.024 487.086C242.024 487.086 239.286 488.515 237.917 491.133C236.548 493.752 236.905 498.513 239.941 496.489C241.965 495.121 244.048 494.466 244.048 491.133C244.108 487.801 243.155 486.372 242.024 487.086ZM234.524 500.12L232.5 502.976H236.727V500.12L235.239 498.513L234.524 500.12V500.12ZM247.5 490.122C247.5 490.122 246.608 492.204 245.893 491.966C245.239 491.728 244.286 496.846 245.893 497.025C247.5 497.203 249.762 494.704 249.762 494.704L251.608 491.193C251.608 491.133 249.584 489.407 247.5 490.122V490.122ZM238.393 404.127C241.37 404.127 245.715 402.758 246.846 402.758C247.977 402.758 255.774 399.783 245.06 397.283C234.346 394.784 234.584 397.283 234.584 397.283H230.179V406.627C230.179 406.627 231.31 407.519 232.441 409.364C233.572 411.209 237.739 415.315 237.143 410.733C236.548 406.15 235.417 404.127 238.393 404.127ZM260.953 430.788C259.108 428.943 262.084 426.206 257.56 421.921C252.977 417.577 251.608 418.529 251.608 414.839C251.608 411.209 249.346 406.15 249.346 406.15H242.977L242.084 407.757V412.816L240.477 413.946L239.167 421.445L240.715 424.421L244.167 426.444L247.381 429.181L249.405 432.574V438.049L251.667 439.894V457.926L250.655 461.794C250.655 461.794 247.56 464.77 247.084 465.9C246.608 467.031 244.822 473.637 245.358 475.482C245.953 477.327 242.5 479.588 244.108 483.694C245.715 487.801 248.215 488.693 249.822 486.848C251.429 485.063 253.929 483.218 255.536 481.611C257.143 480.005 262.858 474.291 264.227 469.53C265.596 464.77 267.62 456.974 268.096 449.475C268.512 441.977 271.251 437.632 260.953 430.788V430.788ZM278.751 450.903C278.751 450.903 278.989 456.378 278.751 459.116C278.512 461.853 276.251 465.067 275.12 467.091C273.989 469.114 271.012 474.351 272.381 477.803C273.751 481.254 273.751 476.434 275.477 472.804C277.203 469.173 280.596 468.935 280.417 462.568C280.12 456.14 281.012 448.166 278.751 450.903V450.903ZM288.096 442.691C288.096 442.691 289.941 451.558 288.096 461.615C286.251 471.673 281.012 480.54 286.965 476.434C292.917 472.328 296.429 470.78 297.679 464.651C300.417 451.498 294.703 445.904 294.703 445.904C294.703 445.904 288.81 440.37 288.096 442.691ZM375.239 531.839C375.239 530.471 374.108 527.257 375.239 526.126C376.37 524.996 375.001 523.389 373.632 522.258C372.263 521.127 372.739 519.282 372.739 518.628C372.739 517.973 372.263 515.414 371.608 514.521C370.953 513.629 370.239 511.308 370.239 511.308L367.977 509.284V511.546H366.37L364.763 514.938V519.699L366.37 523.805V527.436L364.763 529.935L366.37 533.565C366.37 533.565 366.846 536.779 366.37 537.433C365.894 538.088 366.37 541.302 366.37 541.302C366.37 541.302 366.846 541.064 367.977 540.171C369.108 539.278 369.108 536.779 371.37 538.148C373.632 539.516 374.108 536.303 374.108 536.303C374.108 536.303 375.239 533.208 375.239 531.839V531.839ZM362.56 513.807C362.382 514.759 362.322 515.414 362.322 515.414C362.322 515.414 362.501 514.759 362.56 513.807ZM366.786 500.774C366.786 498.989 366.31 493.633 364.763 493.454C364.763 493.454 362.501 496.489 362.501 498.513C362.501 500.536 364.108 500.358 363.632 502.976C363.156 505.595 362.025 507.44 362.501 510.177C362.739 511.546 362.679 512.855 362.62 513.807C362.917 512.26 363.513 509.76 364.763 507.678C366.786 504.226 366.786 502.5 366.786 500.774V500.774ZM329.763 428.527C326.667 425.135 323.691 423.766 323.691 423.766C323.691 423.766 323.215 430.372 323.691 434.002C324.167 437.632 324.346 440.667 326.429 442.096C328.453 443.583 331.191 448.999 333.274 446.976C335.298 444.952 337.382 442.453 334.882 438.525C332.322 434.657 332.858 431.919 329.763 428.527V428.527ZM310.477 427.634C310.477 427.634 310.715 431.502 308.632 431.979C306.608 432.455 304.762 434.478 304.762 437.335C304.762 440.191 300.179 442.155 300.179 442.155C300.179 442.155 306.548 442.215 306.548 447.035C306.548 447.035 309.763 441.143 310.894 439.775C312.024 438.406 315.001 435.43 315.001 433.407C315.001 431.264 316.31 427.337 310.477 427.634V427.634ZM278.274 437.275C280.536 436.501 280.239 432.157 276.191 429.658C272.143 427.158 267.143 427.575 267.143 427.575C267.143 427.575 268.751 430.788 271.012 433.05C273.274 435.371 276.012 438.049 278.274 437.275V437.275ZM232.917 342.354C228.155 341.461 224.048 341.461 224.048 341.461C224.048 341.461 226.786 342.116 229.048 343.961C231.31 345.805 232.917 346.936 235 348.305C237.024 349.674 240.715 350.328 239.108 348.305C237.441 346.222 237.679 343.246 232.917 342.354ZM236.31 376.811C236.548 376.752 236.727 376.752 236.727 376.752C236.548 376.752 236.37 376.752 236.31 376.811ZM236.31 376.811C235.239 376.99 232.441 377.585 231.786 379.251C230.893 381.274 231.608 383.119 232.739 384.726C233.87 386.333 236.131 389.309 237.977 389.071C239.822 388.832 239.584 384.726 237.977 382.941C236.489 381.274 235.239 377.406 236.31 376.811V376.811ZM255.06 498.513L253.929 500.12L256.905 500.774V498.572L256.131 496.608L255.06 498.513V498.513ZM261.429 500.12L263.274 498.513V496.965H261.429V500.12V500.12ZM242.024 464.651H244.048V463.46L243.036 462.27H242.024V464.651ZM245 440.37L244.048 439.477L242.024 442.572H243.036L245 444.714V440.37V440.37ZM319.346 418.707C319.346 415.494 316.072 411.506 311.37 412.816C311.37 412.816 310.001 414.185 311.37 416.446C312.739 418.707 314.346 420.076 315.12 420.076C315.953 420.076 319.346 421.921 319.346 418.707V418.707ZM286.072 442.75C286.727 439.417 284.048 440.37 282.203 440.786C282.203 440.786 280.596 444 282.203 444.655C283.751 445.428 285.358 446.083 286.072 442.75ZM318.691 447.571L319.286 450.487L320.536 447.333L320.477 445.369L318.691 447.571V447.571ZM273.393 446.38L271.965 443.583V446.38L270.953 448.106V450.308L273.393 448.106V446.38V446.38ZM273.393 455.902H274.643L273.393 451.558V455.902ZM246.131 451.558V458.164H248.334L247.262 455.902V453.76L246.131 451.558V451.558Z"
                    fill="#20B67B"
                    fill-opacity="0.1"
                    stroke="url(#paint0_linear_982_14494)"
                  />
                  <g opacity="0.6">
                    <path
                      classNameName="stroke-white"
                      d="M434.762 473.875L434.643 476.553L436.428 480.778L436.667 486.313L438.631 493.871L439.94 499.227L438.155 507.023C437.738 519.699 439.464 534.101 440.357 544.992C441.25 555.882 445 555.406 445 558.739C445 562.071 441.012 565.166 441.012 565.166L437.024 566.059L435.238 559.155L433.69 553.145L429.702 552.014L428.155 554.216H424.821L420.833 553.323V545.527L417.738 544.218H415.059L409.286 548.86L404.821 549.514L404.405 553.74L399.762 555.942L399.524 559.274L399.94 563.262V566.832L399.524 572.188V575.938L401.726 581.472L407.262 588.376V595.696C407.262 595.696 408.571 600.159 410.833 608.55C413.036 617.001 415.297 626.106 412.619 620.75C409.94 615.394 409.286 613.43 408.393 610.514C407.5 607.598 405.059 605.158 402.857 601.825C400.655 598.493 399.94 596.945 398.631 592.72C397.321 588.495 396.845 588.971 395.297 588.495C393.75 588.078 391.964 585.4 390.178 581.413C388.393 577.425 386.19 575.402 383.333 573.2C380.476 570.998 383.095 567.189 383.333 562.964C383.571 558.739 380.595 557.608 380.595 557.608C380.595 557.608 380.416 552.966 377.559 550.526C374.643 548.086 375.119 546.955 374.226 545.646C373.333 544.337 376.905 541.659 376.666 539.457C376.428 537.255 377.083 536.124 378.214 532.792L380.238 526.781C380.238 526.781 381.131 522.556 380.238 520.592C379.345 518.628 376.25 523.27 376.012 520.592C375.774 517.914 372.916 514.402 373.333 510.832C373.75 507.261 370.655 509.284 370 509.284C369.345 509.284 369.107 505.952 369.107 503.512C369.107 501.072 369.107 496.43 368.869 493.097C368.631 489.765 366.845 491.074 366.845 489.348C366.845 487.563 365.535 482.683 365.535 479.588C365.535 476.493 364.643 471.792 363.988 470.066C363.333 468.281 362.202 471.852 360.893 471.852C359.583 471.852 360.893 467.864 360.893 465.662C360.893 463.46 361.309 463.222 362.678 460.782C363.988 458.342 361.785 458.58 360.476 458.342C359.166 458.104 360.238 454.772 360.238 454.772H362.678L366.428 456.081V454.057L367.976 452.034V448.939L368.393 444.952L371.607 442.75L367.678 441.619L365.238 445.845V448.761L362.44 449.237L360.416 451.915L358.869 453.046L356.607 454.176L358.154 458.164C359.285 461.08 359.285 462.806 356.369 461.258C353.452 459.711 355.476 454.355 355.059 449.058C354.643 443.702 352.143 446.38 351.488 441.084C350.833 435.728 344.404 429.062 343.035 425.789C341.726 422.457 336.845 416.684 333.928 414.244C331.012 411.804 330.595 412.042 328.393 410.495C326.19 408.948 326.19 406.269 326.19 404.722C326.19 403.175 328.393 396.926 328.393 393.832C328.393 390.737 325.714 393.593 324.643 397.819C323.571 402.044 320.893 400.259 320.893 402.282C320.893 404.306 318.214 407.817 316.666 406.508C315.119 405.198 314.226 406.091 313.095 406.746C311.964 407.4 309.345 407.638 306.666 408.055C303.988 408.471 302.023 410.733 303.809 410.971C305.595 411.209 306.904 412.756 306.666 414.304C306.428 415.851 303.392 415.613 303.392 415.613C303.392 415.613 308.035 416.744 306.309 424.302C304.523 431.86 294.285 437.156 291.666 437.156C289.047 437.156 282.321 426.265 278.988 423.825C275.654 421.385 273.452 420.731 271.428 419.838C269.404 418.945 268.333 416.506 267.678 414.72C267.023 412.935 264.761 414.72 263.928 412.518C263.095 410.316 257.5 403.175 257.5 403.175C257.5 403.175 256.369 397.64 256.19 394.308C255.952 390.975 250 382.108 250 382.108L245.357 377.644L246.25 368.301L247.142 359.85L248.928 358.303V349.257L244.94 347.234L243.154 344.318V340.092L243.571 333.903L245.595 332.772L247.797 333.427C247.797 333.427 251.369 333.01 252.678 332.534C253.988 332.118 254.702 329.856 254.702 329.856V327.833L253.392 324.917L252.083 325.155L249.88 326.702L247.678 328.487L244.107 330.273L242.083 329.38V326.048L242.976 323.608L245 320.275L247.202 318.49L249.404 316.942L251.071 314.264L248.095 315.157L245.654 317.18L243.095 318.728L241.011 320.275C241.011 320.275 239.702 322.715 236.785 323.608C233.869 324.5 232.797 322.477 232.797 322.477L231.25 321.346L231.011 323.369L232.321 325.571L238.988 325.155V328.904L239.642 333.546L238.333 338.664L233.869 339.735L228.333 339.081H224.761L220.119 338.664H218.333L214.761 336.641L211.845 335.986L207.857 334.855L211.845 338.188L214.94 340.628L219.166 342.83L223.809 347.71L225.714 349.495L228.69 349.733L232.678 351.519L235.595 352.173L240.476 354.613L242.797 359.731L240.952 360.862L240.059 370.384L239.821 371.931L238.69 373.24L237.797 371.038L235.119 372.824L232.023 373.955L229.821 374.847L226.904 375.264V376.573L227.797 378.596V383.06L229.821 385.5L232.916 390.38L234.702 392.582L234.285 394.784L229.404 394.546L227.38 399.426L226.964 404.068L222.738 404.484L224.523 405.377L223.63 407.162L221.428 406.746L219.88 407.638L221.428 409.84L222.976 410.078L225.773 411.864L226.726 410.554H229.821L231.845 417.636L233.154 422.1L229.583 425.849L227.559 427.158L227.321 430.074L225.714 432.276L226.666 434.478L228.69 432.931C228.69 432.931 229.107 431.622 229.999 430.015C230.892 428.467 230.892 426.027 236.011 428.884C241.13 431.8 240.892 435.787 239.583 438.227C238.273 440.667 239.345 441.56 240.476 443.107C241.607 444.655 242.678 447.987 242.678 447.987C243.571 461.556 237.559 465.305 236.011 466.614C234.464 467.924 232.44 464.174 231.547 467.924C230.654 471.673 229.345 476.136 227.083 478.16C224.88 480.183 223.988 477.922 222.857 475.72C221.726 473.518 224.166 471.494 225.654 469.054C227.142 466.614 222.857 466.614 223.511 463.044C224.166 459.473 222.619 457.509 222.619 457.509C221.964 461.496 220.595 464.829 220.595 464.829C222.619 468.816 219.285 473.696 219.285 473.696C219.285 473.696 220.178 477.922 216.369 481.016C212.619 484.111 212.619 493.454 210.178 499.882C207.738 506.309 200.178 507.44 197.083 507.44C193.988 507.44 192.44 502.798 194.404 500.358C196.428 497.918 195.535 494.168 195.535 494.168C195.535 494.168 191.964 499.703 189.761 501.964C187.559 504.166 185.535 500.179 185.535 500.179L185.773 493.276L188.69 490.181L192.44 489.288L192.678 485.718L193.988 482.802L197.083 480.362L199.107 477.922L204.464 475.72L206.011 473.696V467.686L204.464 468.578L202.44 473.458L198.452 473.875L197.142 474.768L194.464 476.553L192.023 481.016L188.928 483.932L188.69 487.503H186.249L184.047 486.61L184.464 483.278L187.142 481.076V475.065L192.023 472.149V469.709L189.107 469.947L185.535 473.934C185.535 473.934 185.535 477.267 182.202 480.838C178.868 484.408 181.964 487.503 180.416 489.05C178.868 490.598 177.737 486.848 177.083 485.956C176.428 485.063 175.059 483.04 175.059 483.04V477.505L175.476 471.494L174.166 467.031L172.857 463.044C171.547 459.056 173.095 454.593 176.428 449.297C179.761 443.94 180.654 443.762 182.44 441.084C184.226 438.406 183.571 435.014 183.571 435.014C181.964 431.383 179.702 439.358 179.702 439.358C179.702 439.358 176.309 446.857 174.226 444.595C172.202 442.334 171.071 446.44 171.071 446.44V450.308L169.94 452.808L168.333 456.438L167.202 461.199L168.333 464.174L169.464 468.043C169.464 468.043 171.309 473.28 170.118 476.731C168.987 480.124 167.38 478.576 165.118 479.707C162.857 480.838 168.749 481.73 168.333 482.921C167.857 484.051 168.095 492.264 168.987 493.871C169.88 495.478 172.38 498.453 170.118 498.632C167.857 498.87 167.618 500.893 165.535 502.976C163.511 505 162.797 504.583 161.428 504.107C160.059 503.631 158.035 504.345 158.035 504.345C158.035 504.345 156.19 505 153.452 504.821C150.714 504.583 150.476 502.56 150.714 499.346C150.952 496.132 148.868 494.585 148.868 494.585L146.606 498.453V503.036L148.452 504.404L151.845 508.749L153.452 510.772L152.321 513.272C150.297 513.51 147.083 512.379 145.714 511.665C144.345 511.01 143.868 512.558 143.868 512.558L145.237 518.033H142.261L139.821 517.676L138.69 514.938V511.546L137.797 509.046L137.142 504.94L138.035 503.095L140.059 501.25L141.428 499.405L142.083 495.775L141.19 489.824L141.666 486.432L144.166 480.481L145.059 477.981L144.821 472.982L144.166 470.483L142.559 468.221L142.797 465.484L144.821 463.222L146.845 460.485V451.558L146.011 453.462L145.714 454.057L142.976 457.45L141.487 461.318V463.163L138.392 466.138C138.392 466.138 139.999 469.114 140.654 470.899C141.309 472.744 142.023 476.374 140.654 479.588C139.285 482.802 138.154 488.455 138.154 488.455C137.499 484.349 138.392 482.088 138.154 479.35C137.916 476.612 137.261 474.768 136.547 473.22C135.892 471.613 134.523 468.876 134.523 468.876C134.523 468.876 133.392 464.532 134.047 460.663C134.702 456.795 133.154 456.557 133.154 456.557L131.13 461.794L130.237 464.293L131.13 467.507L131.785 471.613L132.261 475.72H133.63L135.476 476.196V480.957L133.868 483.456L134.106 486.194L135.476 488.039V497.144L130.297 502.203V510.653C128.69 512.022 128.69 513.153 127.083 515.414C125.476 517.676 123.452 515.176 122.083 513.807C120.714 512.439 121.606 506.487 121.606 506.487L122.083 503.75L123.69 501.905V498.513C123.69 498.513 123.214 495.537 122.083 491.431C120.952 487.325 122.083 486.848 122.083 486.848L119.821 489.11V497.977L117.083 498.632L115.714 502.5L114.345 505.238L113.214 508.451L114.345 510.475L113.214 515.236V519.104C113.214 520.711 109.999 521.841 109.999 521.841H106.606V515.89L105.714 512.022L103.452 509.046V505.833L100.952 507.678L98.6897 509.046L96.4278 505.178L95.535 498.81H94.404L94.6421 494.704L95.535 486.491L93.5112 483.516L92.6183 479.41L94.4635 476.017L96.4873 474.887L98.7493 472.863H97.6183L95.3564 467.15L92.1421 464.413L89.404 458.461C89.404 453.462 88.035 453.224 88.035 453.224C88.035 453.224 88.0349 437.93 87.3802 435.668C86.7254 433.407 83.5111 429.955 83.5111 429.955L85.5349 425.611L84.404 421.505L83.7492 413.53L83.9873 408.055L86.0111 402.58L86.4873 396.45H81.2492V391.213L77.1421 386.869L77.7968 372.288L84.6421 364.968L87.6183 362.231L88.0945 359.969H81.4873C81.4873 359.969 77.6183 358.124 76.2492 356.756C74.8802 355.387 71.6659 358.124 71.6659 358.124H67.0825L65.9516 356.28H61.6063L61.8444 348.305L63.8682 346.282L66.6063 343.782V337.652L68.8683 336.046L70.2373 334.915L69.5825 330.57C69.1063 333.308 64.9992 333.07 64.9992 333.07L63.154 329.678L61.1301 328.071L58.1539 326.702L56.5468 324.203L55.6539 319.62H51.0706L51.3087 315.99H48.8087L49.2849 312.776L49.0468 308.432L50.4158 305.456V302.481L50.6539 299.267L52.4992 297.422L52.7373 291.709H56.6063L59.8206 290.34L62.3206 287.96H64.8206L65.0587 284.627V278.498L65.9516 277.129L66.6063 275.284L65.9516 272.308L62.0825 270.94L62.7373 259.751L65.2373 256.776C66.6063 251.063 63.392 248.801 62.4992 246.718C61.6063 244.635 57.023 245.111 57.023 245.111H46.9634L42.2015 242.374C42.2015 242.374 37.2015 240.112 35.8325 239.636C34.4634 239.16 27.3801 232.554 26.7253 231.186C26.0705 229.817 23.511 228.924 23.511 228.924L19.4039 227.794L11.9039 225.532L8.68956 223.509L6.84432 221.009L5.95146 214.165L3.68955 210.773L1.42764 208.928L0.0585938 205.715L1.66574 203.453L4.40384 200.061V195.955H6.42765L8.0348 192.086L10.7729 190.48L12.6181 188.456L11.9634 183.874L11.0705 180.482L14.4634 179.113L17.6777 177.982L20.892 179.589L21.5467 182.803L24.761 185.302H28.6301L31.6063 182.326L34.3444 178.934L36.1896 174.352L37.3206 170.722L40.9515 167.508L40.7134 158.819C40.7134 158.819 38.8682 153.582 41.3682 151.737C43.8682 149.893 48.4515 154.475 50.8325 154.713C53.2135 154.951 54.5825 152.213 54.5825 152.213H65.0587L68.6897 155.427H73.9278L75.5349 152.928L78.0349 152.69L80.2968 153.582L83.6897 156.796H86.904L88.273 152.035L89.6421 147.929L92.1421 145.905L93.5112 144.536V141.561H85.2968L82.7968 139.537H80.5349L77.3206 137.038V134.3L74.8206 132.039L75.7135 128.647H77.3206V125.433L76.1897 122.696L72.7968 119.958L69.8206 119.72L67.5587 120.196L64.3444 120.851V124.243H59.7611V122.517H57.9158V120.672H49.523L48.1539 119.065V115.911L44.0468 113.888L43.5706 111.388H39.4634L38.9872 102.283C35.7729 98.6528 28.0348 92.7017 28.0348 92.7017L25.2967 89.9641L23.7491 87.4051L19.4039 88.2978C19.4039 88.2978 17.3801 89.1905 14.8205 89.6666C12.3205 90.1427 11.4277 89.6666 11.4277 89.6666L9.58242 86.691L9.34433 82.8227L7.97528 79.4305V74.8481L10.7134 71.8725L12.5586 69.8491V64.7906H15.0586L16.4277 62.5292L15.0586 59.3155V56.1019L16.6658 53.8404V51.1029H18.9872L20.5943 47.4727H26.9634L28.3325 46.3419H31.0706L32.4396 44.9732L31.9634 38.8435L34.2253 37.2366L36.2491 35.2132L39.5825 33.6064V31.9996L42.2015 29.024L44.7015 29.9167H48.1539V28.3099L46.3087 26.703V19.8592L43.5706 18.7285H41.5468L36.5468 16.8836L33.3325 18.7285H31.0706V16.467L32.9158 13.2534L34.761 11.23V4.8622L38.6301 1.64856L39.7611 10.3968H41.5468L43.9873 11.2895L48.4515 14.3841L50.6539 16.8241L52.8563 19.026L57.4992 18.6094L59.7016 21.0494L61.9039 22.8348L63.0349 25.0367L65.4754 28.3694L67.023 29.9167L67.6778 31.9401L67.9159 34.3801L64.8206 36.582C64.8206 36.582 62.142 37.4747 62.142 39.4981C62.142 41.5215 66.6063 37.9508 69.0468 37.9508C71.4873 37.9508 75.2373 38.1888 75.4754 40.3908C75.7135 42.5927 78.3921 44.14 79.7016 42.4142C81.0111 40.6288 82.7968 38.6649 85.4754 39.4981C88.154 40.3908 90.8326 45.0327 90.8326 45.0327H95.9516L96.6064 43.7234L97.9159 41.9381L96.1302 40.6288L94.8207 37.2961L93.035 37.5342L92.3802 33.0708L89.0469 31.0474L87.023 30.6308L86.3683 27.0601L87.4992 24.8582L87.9159 22.6562L90.3564 22.0016L92.1421 24.4416L97.0231 27.1196L100.356 28.0123L101.249 30.6903L102.797 31.583L104.999 31.9996L104.761 35.3323L102.083 34.9157L103.392 39.141L104.285 42.0571L105.595 43.8424L106.725 46.9371L106.964 51.817L108.095 55.5663L111.011 56.2209L114.583 56.6375L117.261 59.5536L118.571 61.577L120.118 64.255L123.035 66.933L127.023 68.0638H129.047L130.833 66.7545L132.38 66.9925L134.583 68.5399L142.142 69.4325C144.821 73.1818 146.785 69.6706 146.785 69.6706L147.023 65.4452L153.035 63.0053L151.904 60.0892L149.226 60.3272L148.571 58.1253L149.94 57.1731L147.916 56.3399L147.678 52.7692L150.357 50.9839L154.106 49.8531L152.321 49.1985L152.083 45.8658H156.726V52.0551L162.737 53.1858L163.868 56.5185L165.178 58.9584L166.964 61.6365L165.654 64.7311L167.44 67.1711L168.749 69.6111L172.321 69.373L172.083 72.4676L170.773 75.1457H174.345C174.345 75.1457 172.142 79.7876 169.464 84.6676C166.785 89.5475 170.118 91.0948 170.118 96.2129C170.118 101.331 175.237 106.211 174.583 109.544C173.928 112.876 171.666 125.731 170.595 135.55C169.464 145.31 174.166 142.632 176.607 142.454C179.047 142.275 188.809 143.584 192.618 147.095C196.368 150.666 202.38 152.63 208.392 152.868C214.404 153.106 218.154 154.892 219.94 156.855C221.726 158.879 226.13 159.295 230.178 157.986C234.166 156.677 234.166 156.677 238.869 156.855C243.511 157.093 241.547 156.439 245.773 155.963C250 155.487 251.13 158.403 253.571 158.403C256.011 158.403 257.559 156.201 260 155.963C262.44 155.725 264.464 158.165 264.464 158.165L268.214 158.581L272.678 158.165L279.107 156.855L282.023 156.439L288.928 153.523L304.047 153.939L307.619 152.154L313.809 157.034L320 157.272L326.666 158.581L333.333 158.819L337.976 155.903L340 159.652L344.881 160.545L347.559 159.236L349.583 157.451L351.785 158.105L353.988 154.773V156.796L359.107 156.558L364.643 156.32L364.881 154.296L370 154.534L372.678 155.665H375.119C375.119 155.665 375.357 154.356 376.666 154.356C377.976 154.356 386.666 155.903 386.666 155.903L391.547 158.998L397.083 160.545L397.738 164.116L405.952 164.354L406.845 166.794L410.833 168.341L415.059 170.127L415.952 175.899L418.869 177.03L422.202 180.601L421.964 185.243L420.178 187.683H416.607L411.071 187.266L408.869 185.719C408.869 185.719 407.083 185.064 403.333 183.933C399.583 182.803 398.69 187.266 398.69 187.266L401.131 191.908V197.919L398.928 202.799L396.25 208.571L395.119 213.451L394.464 219.224L388.928 223.687L389.583 235.471L386.488 238.803H374.047C374.047 238.803 375.595 240.589 375.595 242.552C375.595 244.576 375.357 245.647 373.571 244.1C371.785 242.552 369.821 244.338 369.821 244.338V250.765L370.714 254.514L368.274 254.931L367.857 259.394L367.619 262.31L365.416 262.548L364.285 261.239C364.285 261.239 362.083 259.454 361.369 257.906C360.655 256.359 359.583 255.883 358.274 255.883C356.964 255.883 357.143 254.098 357.143 254.098L353.809 254.514V258.502L353.393 262.489L349.166 262.905C349.166 262.905 347.619 261.358 346.071 257.133C344.524 252.908 343.393 257.549 342.976 261.12C342.559 264.691 341.19 267.785 341.19 267.785L336.547 269.571L331.428 269.333C331.428 269.333 325.416 268.202 322.083 266.893C318.75 265.584 318.095 268.44 318.095 268.44L318.75 273.558L317.202 276.653C317.202 276.653 316.071 279.331 315 279.331C313.869 279.331 309.464 279.985 309.464 279.985L306.369 282.187L304.702 287.96V292.007L305.119 298.672L302.678 303.135L300.654 305.337L295.297 305.575L295.535 309.801L298.214 310.217L301.131 312.062L300.714 315.097L297.619 315.752V320.394L301.607 327.476L300.952 331.047L305.595 334.141L307.619 337.057L307.381 340.628L308.273 344.199L312.5 346.222L310.476 347.769L310.238 349.793L310.654 351.995L311.785 355.744L312.44 360.624L312.678 364.611C312.678 364.611 312.678 367.289 314.464 372.586C318.214 379.013 320.238 375.918 320.238 375.918L319.821 371.931L318.035 366.813L318.452 362.35V358.6L320.654 355.922H323.75L324.643 358.362L326.845 358.779L327.738 361.457L329.285 362.766V365.861L330.595 368.539V370.741L331.726 373.836L332.381 377.406L333.928 378.954L335.476 383.595V385.797L338.154 386.214C338.154 386.214 340.178 390.201 341.488 390.201C342.797 390.201 343.274 388.178 344.821 385.738C346.369 383.298 352.797 382.643 354.821 382.405C356.845 382.167 356.607 380.382 356.607 377.763C356.607 375.085 358.631 374.669 359.702 372.645C360.774 370.622 357.916 365.563 356.785 363.123C355.654 360.683 355.476 356.22 355.476 355.149C355.476 354.078 358.809 346.043 358.809 346.043C358.809 346.043 359.464 342.711 365.238 338.724C371.012 336.7 371.905 334.736 373.214 333.189C374.524 331.642 374.345 326.762 374.345 326.762L373.035 321.406L372.143 316.288C372.143 316.288 371.726 309.622 371.905 307.42C372.143 305.218 374.583 308.968 374.583 308.968L376.785 311.943L379.881 314.324C379.881 314.324 381.666 314.978 383.631 314.324C385.595 313.669 388.988 308.789 388.988 308.789L392.738 306.587L394.94 306.825L396.964 308.611L397.202 312.003L397.44 314.562L399.226 314.8L399.881 313.669C399.881 313.669 399.226 311.467 400.774 308.789C402.321 306.111 405 310.098 405 310.098L404.583 315.633L403.928 320.096L406.131 322.298L407.678 325.869V329.44L408.988 337.652L409.226 339.2L411.428 339.616L411.845 343.187L412.738 344.734L413.631 349.852L414.286 352.768L413.631 354.97L411.19 358.72L412.083 372.288L414.762 376.633V389.725L419.107 396.212L422.976 402.639L423.214 405.734L423.631 409.067L425.178 409.721L426.726 410.614L428.928 412.637L429.167 422.159L430.297 423.468L430.059 426.563L428.512 428.11L428.274 430.788L430.297 432.098L430.714 439.418L430.952 447.63L434.047 450.546L434.464 455.664L434.702 460.128L434.94 469.233L434.762 473.875V473.875ZM91.0111 498.513V501.905L92.3802 500.179V508.749L94.6421 511.486L97.6183 514.224C97.6183 514.224 101.964 517.2 100.356 514.224C98.7493 511.248 96.1302 509.88 95.8326 509.642L94.404 508.511L93.9278 500.298L94.1659 498.691L91.0111 498.513V498.513ZM117.975 501.726V505.833L119.345 503.75L120.892 501.726V500.12L117.975 501.726ZM117.975 517.676V519.282L120.892 518.509L119.404 516.545L117.975 517.676ZM221.071 483.694L220.119 482.326L221.071 479.588H222.559L223.571 481.671L222.559 482.802L221.071 483.694ZM223.571 487.563L222.559 490.955L221.845 493.692L220.119 495.954V498.453C220.119 498.453 222.738 497.323 225.773 495.24C228.809 493.157 231.785 490.003 231.309 487.503C230.833 485.004 229.464 483.635 229.464 483.635H227.44L225.773 484.528L223.571 487.563V487.563ZM242.023 468.459C242.023 468.459 237.916 471.197 237.023 472.804C236.13 474.41 231.19 477.386 231.369 478.755C231.547 480.124 231.369 484.706 231.369 484.706C231.369 484.706 232.023 488.336 234.285 486.729C236.547 485.123 236.785 483.099 237.916 481.73C239.047 480.362 239.94 479.469 240.416 475.601C240.892 471.613 242.023 468.459 242.023 468.459ZM242.023 487.087C242.023 487.087 239.285 488.515 237.916 491.133C236.547 493.752 236.904 498.513 239.94 496.489C241.964 495.121 244.047 494.466 244.047 491.133C244.107 487.801 243.154 486.372 242.023 487.087ZM235.178 498.513L234.523 500.12L232.44 502.976H236.666V500.12L235.178 498.513ZM247.5 490.122C247.5 490.122 246.607 492.205 245.892 491.966C245.238 491.728 244.285 496.846 245.892 497.025C247.5 497.204 249.761 494.704 249.761 494.704L251.607 491.193C251.607 491.133 249.583 489.407 247.5 490.122V490.122ZM230.178 397.283V406.627C230.178 406.627 231.309 407.519 232.44 409.364C233.571 411.209 237.738 415.315 237.142 410.733C236.547 406.15 235.416 404.127 238.333 404.127C241.309 404.127 245.654 402.758 246.785 402.758C247.916 402.758 255.714 399.783 245 397.283C234.285 394.784 234.523 397.283 234.523 397.283H230.178V397.283ZM249.345 406.15H242.976L242.083 407.757V412.816L240.476 413.946L239.166 421.445L240.714 424.421L244.166 426.444L247.38 429.182L249.404 432.574V438.049L251.666 439.894V457.866L250.654 461.734C250.654 461.734 247.559 464.71 247.083 465.841C246.607 466.972 244.821 473.577 245.357 475.422C245.952 477.267 242.5 479.529 244.107 483.635C245.714 487.741 248.214 488.634 249.821 486.789C251.428 485.004 253.928 483.159 255.535 481.552C257.142 479.945 262.857 474.232 264.226 469.471C265.595 464.71 267.619 456.914 268.095 449.416C268.571 441.917 271.309 437.573 261.011 430.729C259.166 428.884 262.142 426.146 257.619 421.862C253.035 417.517 251.666 418.469 251.666 414.78C251.607 411.209 249.345 406.15 249.345 406.15V406.15ZM278.75 450.903C278.75 450.903 278.988 456.378 278.75 459.116C278.511 461.853 276.25 465.067 275.119 467.091C273.988 469.114 271.011 474.351 272.381 477.803C273.75 481.254 273.75 476.434 275.476 472.804C277.202 469.173 280.595 468.935 280.416 462.568C280.119 456.14 281.011 448.166 278.75 450.903V450.903ZM297.678 464.651C296.428 470.78 292.916 472.328 286.964 476.434C281.012 480.54 286.309 471.673 288.095 461.615C289.94 451.558 288.095 442.691 288.095 442.691C288.75 440.429 294.702 445.904 294.702 445.904C294.702 445.904 300.416 451.498 297.678 464.651ZM367.916 509.225V511.486H366.309L364.702 514.879V519.639L366.309 523.746V527.376L364.702 529.876L366.309 533.506C366.309 533.506 366.785 536.719 366.309 537.374C365.833 538.029 366.309 541.242 366.309 541.242C366.309 541.242 366.785 541.004 367.916 540.112C369.047 539.219 369.047 536.719 371.309 538.088C373.571 539.457 374.047 536.243 374.047 536.243C374.047 536.243 375.178 533.03 375.178 531.661C375.178 530.292 374.047 527.078 375.178 525.948C376.309 524.817 374.94 523.21 373.571 522.079C372.202 520.949 372.678 519.104 372.678 518.449C372.678 517.795 372.202 515.236 371.547 514.343C370.893 513.45 370.178 511.129 370.178 511.129L367.916 509.225V509.225ZM364.762 493.454C364.762 493.454 362.5 496.489 362.5 498.513C362.5 500.536 364.107 500.358 363.631 502.976C363.155 505.595 362.024 507.44 362.5 510.177C362.976 512.915 362.381 515.414 362.381 515.414C362.381 515.414 362.738 511.07 364.762 507.678C366.785 504.285 366.785 502.56 366.785 500.774C366.785 498.989 366.309 493.633 364.762 493.454Z"
                      stroke="url(#paint1_linear_982_14494)"
                      stroke-miterlimit="10"
                      stroke-linejoin="round"
                    />
                    <path
                      d="M323.691 423.766C323.691 423.766 323.215 430.372 323.691 434.002C324.167 437.632 324.346 440.667 326.429 442.096C328.453 443.583 331.191 448.999 333.274 446.976C335.298 444.952 337.381 442.453 334.881 438.525C332.381 434.657 332.858 431.919 329.762 428.467C326.667 425.135 323.691 423.766 323.691 423.766V423.766ZM300.179 442.096C300.179 442.096 306.548 442.155 306.548 446.976C306.548 446.976 309.762 441.084 310.893 439.715C312.024 438.346 315 435.371 315 433.347C315 431.324 316.31 427.337 310.417 427.634C310.417 427.634 310.655 431.502 308.572 431.979C306.548 432.455 304.703 434.478 304.703 437.335C304.703 440.191 300.179 442.096 300.179 442.096V442.096ZM267.143 427.575C267.143 427.575 268.75 430.788 271.012 433.05C273.274 435.311 276.012 438.049 278.334 437.275C280.596 436.501 280.298 432.157 276.25 429.658C272.143 427.158 267.143 427.575 267.143 427.575V427.575ZM223.988 341.402C223.988 341.402 226.726 342.056 228.988 343.901C231.25 345.746 232.857 346.877 234.941 348.245C236.964 349.614 240.655 350.269 239.048 348.245C237.441 346.222 237.679 343.246 232.917 342.294C228.095 341.402 223.988 341.402 223.988 341.402V341.402ZM236.667 376.752C236.667 376.752 232.619 377.228 231.726 379.251C230.834 381.275 231.548 383.119 232.679 384.726C233.81 386.333 236.072 389.309 237.917 389.071C239.762 388.833 239.524 384.726 237.917 382.941C236.31 381.096 235 376.514 236.667 376.752V376.752ZM256.072 496.549L255.06 498.513L253.869 500.12L256.845 500.774V498.513L256.072 496.549ZM261.429 500.12L263.215 498.513V496.965H261.429V498.572V500.12ZM242.024 462.27V464.651H244.107V463.46L243.036 462.27H242.024ZM245 440.37V444.714L243.036 442.572H242.024L244.107 439.477L245 440.37ZM311.369 412.816C311.369 412.816 310 414.185 311.369 416.446C312.738 418.707 314.346 420.076 315.119 420.076C315.893 420.076 319.346 421.921 319.346 418.707C319.346 415.553 316.072 411.506 311.369 412.816V412.816ZM282.143 440.846C282.143 440.846 280.536 444.059 282.143 444.714C283.75 445.369 285.357 446.083 286.012 442.75C286.726 439.477 283.988 440.37 282.143 440.846ZM318.691 447.571L319.227 450.546L320.536 447.333L320.417 445.369L318.691 447.571ZM272.024 443.583V446.38L271.012 448.106V450.308L273.393 448.106V446.38L272.024 443.583ZM273.393 451.558V455.902H274.643L273.393 451.558ZM246.131 451.558V458.164H248.334L247.203 455.902V453.7L246.131 451.558Z"
                      stroke="url(#paint2_linear_982_14494)"
                      stroke-miterlimit="10"
                      stroke-linejoin="round"
                    />
                  </g>
                  <path
                    d="M65.0599 256.835C65.0599 256.835 64.5242 269.511 74.2861 266.417C84.0481 263.322 89.1671 256.121 93.81 266.893C98.4528 277.724 93.81 282.842 109.227 284.865C124.643 286.889 123.512 290.995 120.953 298.196C118.453 305.397 114.643 311.467 122.441 312.003C130.239 312.538 135.358 318.192 134.822 320.751C134.286 323.31 138.929 327.238 138.929 327.238L135.715 329.499L136.905 331.166C136.905 331.166 138.453 329.975 140.536 329.975C142.56 329.975 141.548 332.237 145.536 336.522C146.072 337.117 147.62 341.045 144.882 341.461C142.143 341.937 146.251 347.472 146.251 347.472C146.251 347.472 146.727 352.233 148.096 352.233H152.679C152.679 352.233 148.572 355.446 149.465 356.994C150.358 358.601 152.203 356.756 152.679 359.017C153.155 361.279 153.572 364.968 154.941 364.73C156.31 364.492 160.179 362.707 160.179 362.707V366.337H157.441L157.917 369.075H154.703L154.465 372.705C154.465 372.705 157.203 374.728 159.227 376.573C161.251 378.418 164.227 384.131 168.334 388.892C172.441 393.653 178.155 397.759 179.048 398.89C179.941 400.021 177.679 401.866 177.679 401.866L179.286 404.306L178.155 405.972H176.786L178.155 409.364L176.132 411.209L173.155 412.578L173.632 413.708H177.263V416.386L175.417 417.398V418.767L176.548 420.433L177.441 423.587L180.179 425.194C180.179 425.194 181.548 428.586 180.179 429.539C178.81 430.431 177.679 430.431 178.81 432.395C179.941 434.359 181.132 435.49 181.132 435.49"
                    stroke="url(#paint3_linear_982_14494)"
                    stroke-miterlimit="10"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                  />
                  <path
                    d="M121.191 288.912C121.191 288.912 129.108 290.578 134.168 293.792C139.168 297.006 140.299 296.768 144.644 295.816C148.989 294.923 152.62 291.114 155.596 292.661C158.572 294.209 152.858 284.211 157.203 279.628C161.549 275.046 170.656 275.76 169.049 265.941C167.441 256.121 162.441 242.671 162.441 236.304C162.441 229.936 160.834 232.673 161.072 230.174C161.311 227.674 162.68 225.413 162.68 222.199C162.68 218.986 164.703 214.879 166.072 216.248C166.072 216.248 168.037 215.594 169.227 213.273C170.418 211.011 170.418 209.404 172.441 208.512C174.465 207.619 172.441 203.929 172.441 203.929L173.334 202.56L176.072 200.061L177.918 197.8L179.942 199.823C179.942 199.823 180.596 202.322 183.572 199.168C186.549 195.955 191.787 195.776 191.787 195.776L193.632 198.276V200.775L195.894 200.12V204.703L198.394 208.333V222.199L200.894 223.806L203.632 224.699V228.091L205.001 232.197L205.894 236.304L207.739 242.017L208.632 246.064C208.632 246.064 208.87 247.73 211.132 247.73C213.394 247.73 217.501 249.218 219.584 246.064C221.608 242.909 222.977 250.884 226.906 244.754C230.775 238.625 230.775 242.493 234.227 244.754C237.62 247.016 244.287 254.038 246.787 246.064C249.287 238.149 249.763 234.042 244.287 231.305C238.811 228.567 241.073 224.699 245.894 225.83C250.656 226.96 250.239 226.96 252.263 226.068C254.287 225.175 258.632 226.722 261.132 224.044C263.632 221.307 265.239 217.676 269.585 217.2C273.93 216.724 277.799 215.594 280.061 215.356C282.323 215.117 284.406 213.987 286.013 213.987C287.62 213.987 288.751 215.832 290.596 216.01C292.442 216.248 296.966 214.879 297.918 214.403C298.811 213.927 297.918 216.903 301.787 218.986C305.656 221.009 301.311 223.568 299.942 225.353C298.573 227.198 298.573 227.377 301.073 228.746C303.573 230.114 301.727 232.614 301.727 232.614L303.275 236.958V240.827C303.275 241.065 300.358 242.433 302.144 243.564C303.989 244.695 304.644 245.766 301.668 246.004C298.692 246.302 298.275 246.302 298.037 248.563C297.799 250.825 301.251 252.193 296.668 252.669C292.085 253.146 290.715 255.407 290.299 256.776C289.823 258.145 290.061 257.43 286.192 257.906C282.323 258.383 280.477 260.406 281.846 262.251C283.216 264.096 288.454 268.202 284.823 272.308C281.192 276.415 280.715 274.332 279.346 280.997C277.977 287.603 279.108 285.996 275.001 290.102C270.894 294.209 267.918 294.685 262.442 294.685C256.965 294.685 256.965 293.554 257.68 299.922C258.334 306.29 254.704 303.314 254.704 306.29C254.704 309.265 253.811 311.765 256.073 314.502C258.334 317.24 260.656 317.716 257.442 319.263C254.227 320.87 257.144 324.917 253.096 325.036M175.775 396.212H181.192C181.192 396.212 183.215 395.26 185.061 393.177C186.906 391.153 191.013 388.416 191.906 385.44C192.799 382.465 197.62 376.752 197.62 376.752C197.62 376.752 202.203 373.538 203.334 376.752C204.465 379.965 205.596 386.095 207.442 385.738C209.287 385.381 214.942 388.356 214.942 382.881C214.942 377.406 214.049 374.431 218.573 376.692C223.156 378.954 225.12 380.62 227.858 378.537L175.775 396.212Z"
                    stroke="url(#paint4_linear_982_14494)"
                    stroke-miterlimit="10"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                  />
                  <path
                    d="M92.2031 145.786C92.2031 145.786 96.0722 145.31 99.0484 145.786C102.025 146.262 106.786 149 108.394 148.762C110.001 148.524 111.37 155.13 111.37 155.13C111.132 157.391 112.977 162.628 115.715 163.104C118.453 163.58 117.739 161.259 120.477 163.104C123.215 164.949 126.191 168.103 129.584 167.449C132.977 166.794 136.429 166.496 140.775 167.568C145.12 168.639 150.12 168.639 150.12 168.639C152.62 168.163 152.62 168.639 152.62 171.376C152.62 174.114 150.358 176.137 152.62 181.612C154.882 187.087 153.751 189.587 157.203 192.801C160.596 196.014 166.072 198.514 165.656 202.382C165.179 206.25 166.846 214.879 162.858 220.593M171.489 128.111C171.489 128.111 170.894 131.86 167.918 132.753C164.941 133.646 162.918 133.646 162.918 138.704C162.918 143.703 164.941 146.917 161.31 149.893C157.679 152.868 158.572 154.237 156.548 158.998C154.525 163.759 156.132 165.009 152.203 168.639M274.168 158.998C274.168 158.998 273.275 160.367 274.168 163.58C275.061 166.794 276.43 168.341 274.168 171.317C271.906 174.292 271.787 174.947 273.751 178.637C275.775 182.267 276.43 185.243 278.513 186.373C280.537 187.504 284.644 187.98 287.858 187.504C291.073 187.028 293.573 184.29 293.989 193.217C294.465 202.084 293.751 204.822 297.62 205.774C301.489 206.667 302.382 206.905 301.251 209.642C300.12 212.38 297.977 214.403 298.573 215.653L274.168 158.998Z"
                    stroke="url(#paint5_linear_982_14494)"
                    stroke-miterlimit="10"
                    stroke-linecap="round"
                    stroke-linejoin="round"
                  />
                  <path
                    d="M124.837 110.184C129.157 113.388 135.203 112.525 138.341 108.255C141.48 103.987 140.521 97.9275 136.201 94.7229C131.883 91.5183 125.836 92.3824 122.699 96.6511C119.56 100.92 120.517 106.979 124.837 110.184Z"
                    fill="url(#paint6_radial_982_14494)"
                  />
                  <path
                    d="M128.312 105.46C129.992 106.706 132.343 106.37 133.563 104.71C134.784 103.05 134.411 100.693 132.731 99.4471C131.052 98.2008 128.7 98.5369 127.48 100.197C126.26 101.857 126.632 104.213 128.312 105.46Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M34.3726 65.3047C38.6925 68.5094 44.7378 67.6464 47.8763 63.3765C51.0147 59.1078 50.0564 53.0486 45.7365 49.844C41.4177 46.6394 35.3712 47.5035 32.234 51.7722C29.0955 56.041 30.0526 62.1001 34.3726 65.3047Z"
                    fill="url(#paint7_radial_982_14494)"
                  />
                  <path
                    d="M37.8469 60.5807C39.5269 61.827 41.8779 61.4914 43.0984 59.8308C44.3189 58.1708 43.9462 55.8144 42.2662 54.5682C40.5867 53.3219 38.2353 53.658 37.0152 55.3181C35.7947 56.9781 36.1669 59.3345 37.8469 60.5807Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M52.285 31.474C55.0621 33.5342 58.9484 32.9794 60.9659 30.2345C62.9835 27.4903 62.3675 23.5951 59.5903 21.535C56.814 19.4749 52.927 20.0304 50.9102 22.7746C48.8926 25.5188 49.5079 29.4139 52.285 31.474Z"
                    fill="url(#paint8_radial_982_14494)"
                  />
                  <path
                    d="M54.516 28.4372C55.596 29.2384 57.1073 29.0227 57.8919 27.9552C58.6765 26.888 58.437 25.3732 57.357 24.5721C56.2773 23.7709 54.7657 23.9869 53.9813 25.0541C53.1967 26.1213 53.436 27.6361 54.516 28.4372Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M68.8592 56.33C71.6363 58.3901 75.5226 57.8354 77.5401 55.0904C79.5577 52.3463 78.9417 48.4511 76.1646 46.391C73.3882 44.3308 69.5012 44.8864 67.4844 47.6306C65.4668 50.3747 66.0821 54.2699 68.8592 56.33Z"
                    fill="url(#paint9_radial_982_14494)"
                  />
                  <path
                    d="M71.0902 53.2932C72.1702 54.0944 73.6815 53.8786 74.4661 52.8111C75.2507 51.744 75.0112 50.2292 73.9312 49.428C72.8515 48.6268 71.3399 48.8429 70.5556 49.9101C69.771 50.9772 70.0102 52.492 71.0902 53.2932Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M98.5545 62.544C101.332 64.6041 105.218 64.0494 107.235 61.3044C109.253 58.5602 108.637 54.6651 105.86 52.605C103.084 50.5448 99.1965 51.1004 97.1797 53.8445C95.1621 56.5887 95.7774 60.4839 98.5545 62.544Z"
                    fill="url(#paint10_radial_982_14494)"
                  />
                  <path
                    d="M100.786 59.5072C101.866 60.3083 103.377 60.0926 104.161 59.0251C104.946 57.9579 104.706 56.4432 103.627 55.642C102.547 54.8408 101.035 55.0569 100.251 56.1241C99.4663 57.1912 99.7055 58.706 100.786 59.5072Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M52.285 84.6382C55.0621 86.6984 58.9484 86.1436 60.9659 83.3987C62.9835 80.6545 62.3675 76.7593 59.5903 74.6992C56.814 72.6391 52.927 73.1946 50.9102 75.9388C48.8926 78.683 49.5079 82.5781 52.285 84.6382Z"
                    fill="url(#paint11_radial_982_14494)"
                  />
                  <path
                    d="M54.516 81.6014C55.596 82.4026 57.1073 82.1869 57.8919 81.1194C58.6765 80.0522 58.437 78.5374 57.357 77.7362C56.2773 76.9351 54.7657 77.1511 53.9813 78.2183C53.1967 79.2855 53.436 80.8003 54.516 81.6014Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M61.2615 179.229C64.0387 181.289 67.9249 180.734 69.9425 177.989C71.9601 175.245 71.344 171.35 68.5669 169.29C65.7906 167.23 61.9035 167.785 59.8867 170.53C57.8692 173.274 58.4844 177.169 61.2615 179.229Z"
                    fill="url(#paint12_radial_982_14494)"
                  />
                  <path
                    d="M63.4926 176.192C64.5725 176.993 66.0839 176.778 66.8685 175.71C67.6531 174.643 67.4135 173.128 66.3335 172.327C65.2538 171.526 63.7422 171.742 62.9579 172.809C62.1733 173.876 62.4126 175.391 63.4926 176.192Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M153.109 85.3287C155.886 87.3888 159.773 86.8341 161.79 84.0891C163.808 81.3449 163.192 77.4497 160.415 75.3896C157.638 73.3295 153.751 73.885 151.734 76.6292C149.717 79.3734 150.332 83.2685 153.109 85.3287Z"
                    fill="url(#paint13_radial_982_14494)"
                  />
                  <path
                    d="M155.34 82.2919C156.42 83.093 157.932 82.8773 158.716 81.8098C159.501 80.7426 159.261 79.2278 158.181 78.4267C157.101 77.6255 155.59 77.8415 154.806 78.9087C154.021 79.9759 154.26 81.4907 155.34 82.2919Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M137.918 166.111C140.695 168.171 144.581 167.616 146.599 164.871C148.616 162.127 148 158.232 145.223 156.172C142.447 154.111 138.56 154.667 136.543 157.411C134.525 160.155 135.141 164.051 137.918 166.111Z"
                    fill="url(#paint14_radial_982_14494)"
                  />
                  <path
                    d="M140.149 163.074C141.229 163.875 142.74 163.659 143.525 162.592C144.309 161.525 144.07 160.01 142.99 159.209C141.91 158.407 140.398 158.624 139.614 159.691C138.83 160.758 139.069 162.273 140.149 163.074Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M14.3006 209.609C17.0777 211.669 20.964 211.114 22.9816 208.369C24.9991 205.625 24.3831 201.73 21.606 199.67C18.8296 197.609 14.9426 198.165 12.9258 200.909C10.9082 203.653 11.5235 207.548 14.3006 209.609Z"
                    fill="url(#paint15_radial_982_14494)"
                  />
                  <path
                    d="M16.5316 206.572C17.6116 207.373 19.1229 207.157 19.9075 206.09C20.6921 205.023 20.4526 203.508 19.3726 202.707C18.2929 201.905 16.7813 202.121 15.997 203.189C15.2124 204.256 15.4516 205.771 16.5316 206.572Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M88.8826 208.228C91.6597 210.288 95.546 209.733 97.5636 206.988C99.5811 204.244 98.9651 200.349 96.188 198.289C93.4117 196.229 89.5246 196.784 87.5078 199.528C85.4903 202.272 86.1055 206.168 88.8826 208.228Z"
                    fill="url(#paint16_radial_982_14494)"
                  />
                  <path
                    d="M91.1136 205.191C92.1936 205.992 93.705 205.776 94.4896 204.709C95.2742 203.642 95.0346 202.127 93.9546 201.326C92.8749 200.525 91.3633 200.741 90.579 201.808C89.7944 202.875 90.0337 204.39 91.1136 205.191Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M117.199 276.582C119.976 278.642 123.862 278.087 125.88 275.342C127.898 272.598 127.282 268.703 124.504 266.643C121.728 264.583 117.841 265.138 115.824 267.882C113.807 270.626 114.422 274.522 117.199 276.582Z"
                    fill="url(#paint17_radial_982_14494)"
                  />
                  <path
                    d="M119.43 273.545C120.51 274.346 122.021 274.13 122.806 273.063C123.591 271.996 123.351 270.481 122.271 269.68C121.191 268.879 119.68 269.095 118.895 270.162C118.111 271.229 118.35 272.744 119.43 273.545Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M161.394 188.895C164.171 190.955 168.058 190.401 170.075 187.656C172.093 184.912 171.477 181.016 168.7 178.956C165.923 176.896 162.036 177.452 160.02 180.196C158.002 182.94 158.617 186.835 161.394 188.895Z"
                    fill="url(#paint18_radial_982_14494)"
                  />
                  <path
                    d="M163.625 185.859C164.705 186.66 166.217 186.444 167.001 185.376C167.786 184.309 167.546 182.794 166.466 181.993C165.387 181.192 163.875 181.408 163.091 182.475C162.306 183.543 162.545 185.057 163.625 185.859Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M212.5 194.419C215.277 196.479 219.163 195.924 221.181 193.179C223.198 190.435 222.582 186.54 219.805 184.48C217.029 182.42 213.142 182.975 211.125 185.719C209.107 188.463 209.723 192.359 212.5 194.419Z"
                    fill="url(#paint19_radial_982_14494)"
                  />
                  <path
                    d="M214.731 191.382C215.811 192.183 217.322 191.967 218.107 190.9C218.891 189.833 218.652 188.318 217.572 187.517C216.492 186.716 214.98 186.932 214.196 187.999C213.412 189.066 213.651 190.581 214.731 191.382Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M245.648 178.539C248.425 180.599 252.312 180.044 254.329 177.299C256.347 174.555 255.731 170.66 252.954 168.6C250.177 166.539 246.29 167.095 244.273 169.839C242.256 172.583 242.871 176.479 245.648 178.539Z"
                    fill="url(#paint20_radial_982_14494)"
                  />
                  <path
                    d="M247.879 175.502C248.959 176.303 250.471 176.087 251.255 175.02C252.04 173.953 251.8 172.438 250.72 171.637C249.641 170.835 248.129 171.052 247.345 172.119C246.56 173.186 246.799 174.701 247.879 175.502Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M258.769 213.061C261.546 215.121 265.433 214.566 267.45 211.821C269.468 209.077 268.852 205.182 266.075 203.122C263.298 201.062 259.411 201.617 257.395 204.361C255.377 207.106 255.992 211.001 258.769 213.061Z"
                    fill="url(#paint21_radial_982_14494)"
                  />
                  <path
                    d="M261 210.024C262.08 210.825 263.592 210.609 264.376 209.542C265.161 208.475 264.921 206.96 263.841 206.159C262.762 205.358 261.25 205.574 260.466 206.641C259.681 207.708 259.92 209.223 261 210.024Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M271.89 247.583C274.668 249.643 278.554 249.088 280.571 246.343C282.589 243.599 281.973 239.704 279.196 237.644C276.419 235.584 272.532 236.139 270.516 238.884C268.498 241.628 269.113 245.523 271.89 247.583Z"
                    fill="url(#paint22_radial_982_14494)"
                  />
                  <path
                    d="M274.121 244.546C275.201 245.347 276.713 245.132 277.497 244.064C278.282 242.997 278.042 241.482 276.962 240.681C275.883 239.88 274.371 240.096 273.587 241.163C272.802 242.23 273.041 243.745 274.121 244.546Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M251.863 282.796C254.64 284.856 258.526 284.301 260.544 281.556C262.562 278.812 261.946 274.917 259.168 272.857C256.392 270.797 252.505 271.352 250.488 274.096C248.471 276.84 249.086 280.736 251.863 282.796Z"
                    fill="url(#paint23_radial_982_14494)"
                  />
                  <path
                    d="M254.094 279.759C255.174 280.56 256.685 280.344 257.47 279.277C258.255 278.21 258.015 276.695 256.935 275.894C255.855 275.093 254.344 275.309 253.559 276.376C252.775 277.443 253.014 278.958 254.094 279.759Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M226.312 266.915C229.089 268.976 232.976 268.421 234.993 265.676C237.011 262.932 236.395 259.037 233.618 256.976C230.841 254.916 226.954 255.472 224.938 258.216C222.92 260.96 223.535 264.855 226.312 266.915Z"
                    fill="url(#paint24_radial_982_14494)"
                  />
                  <path
                    d="M228.543 263.879C229.623 264.68 231.135 264.464 231.919 263.397C232.704 262.329 232.464 260.815 231.384 260.013C230.305 259.212 228.793 259.428 228.009 260.496C227.224 261.563 227.463 263.077 228.543 263.879Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M199.379 260.011C202.156 262.071 206.042 261.516 208.06 258.771C210.077 256.027 209.461 252.132 206.684 250.072C203.908 248.012 200.021 248.567 198.004 251.312C195.986 254.056 196.602 257.951 199.379 260.011Z"
                    fill="url(#paint25_radial_982_14494)"
                  />
                  <path
                    d="M201.61 256.974C202.69 257.775 204.201 257.56 204.986 256.492C205.77 255.425 205.531 253.91 204.451 253.109C203.371 252.308 201.859 252.524 201.075 253.591C200.29 254.658 200.53 256.173 201.61 256.974Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M180.734 224.108C183.511 226.168 187.398 225.613 189.415 222.868C191.433 220.124 190.817 216.229 188.04 214.169C185.263 212.109 181.376 212.664 179.359 215.409C177.342 218.153 177.957 222.048 180.734 224.108Z"
                    fill="url(#paint26_radial_982_14494)"
                  />
                  <path
                    d="M182.965 221.071C184.045 221.872 185.557 221.657 186.341 220.589C187.126 219.522 186.886 218.007 185.806 217.206C184.726 216.405 183.215 216.621 182.431 217.688C181.646 218.755 181.885 220.27 182.965 221.071Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M171.066 247.583C173.843 249.643 177.73 249.088 179.747 246.343C181.765 243.599 181.149 239.704 178.372 237.644C175.595 235.584 171.708 236.139 169.691 238.884C167.674 241.628 168.289 245.523 171.066 247.583Z"
                    fill="url(#paint27_radial_982_14494)"
                  />
                  <path
                    d="M173.297 244.546C174.377 245.347 175.889 245.132 176.673 244.064C177.458 242.997 177.218 241.482 176.138 240.681C175.059 239.88 173.547 240.096 172.763 241.163C171.978 242.23 172.217 243.745 173.297 244.546Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M160.015 295.224C162.793 297.284 166.679 296.729 168.696 293.984C170.714 291.24 170.098 287.345 167.321 285.285C164.544 283.225 160.657 283.78 158.641 286.524C156.623 289.268 157.238 293.164 160.015 295.224Z"
                    fill="url(#paint28_radial_982_14494)"
                  />
                  <path
                    d="M162.246 292.187C163.326 292.988 164.838 292.772 165.622 291.705C166.407 290.638 166.167 289.123 165.087 288.322C164.008 287.521 162.496 287.737 161.712 288.804C160.927 289.871 161.166 291.386 162.246 292.187Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M131.699 309.723C134.476 311.783 138.362 311.228 140.38 308.483C142.398 305.739 141.782 301.844 139.004 299.784C136.228 297.724 132.341 298.279 130.324 301.023C128.307 303.768 128.922 307.663 131.699 309.723Z"
                    fill="url(#paint29_radial_982_14494)"
                  />
                  <path
                    d="M133.93 306.686C135.01 307.487 136.521 307.272 137.306 306.204C138.091 305.137 137.851 303.622 136.771 302.821C135.691 302.02 134.18 302.236 133.395 303.303C132.611 304.37 132.85 305.885 133.93 306.686Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M158.633 342.174C161.41 344.234 165.296 343.679 167.314 340.934C169.331 338.19 168.715 334.295 165.938 332.235C163.162 330.175 159.275 330.73 157.258 333.474C155.24 336.219 155.856 340.114 158.633 342.174Z"
                    fill="url(#paint30_radial_982_14494)"
                  />
                  <path
                    d="M160.864 339.137C161.944 339.938 163.455 339.722 164.24 338.655C165.024 337.588 164.785 336.073 163.705 335.272C162.625 334.471 161.113 334.687 160.329 335.754C159.544 336.821 159.784 338.336 160.864 339.137Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M202.832 354.602C205.609 356.662 209.495 356.107 211.513 353.362C213.53 350.618 212.914 346.723 210.137 344.663C207.361 342.603 203.474 343.158 201.457 345.902C199.439 348.647 200.055 352.542 202.832 354.602Z"
                    fill="url(#paint31_radial_982_14494)"
                  />
                  <path
                    d="M205.063 351.565C206.143 352.366 207.654 352.15 208.439 351.083C209.223 350.016 208.984 348.501 207.904 347.7C206.824 346.899 205.313 347.115 204.528 348.182C203.744 349.249 203.983 350.764 205.063 351.565Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M222.168 316.627C224.945 318.688 228.831 318.133 230.849 315.388C232.866 312.644 232.25 308.749 229.473 306.688C226.697 304.628 222.81 305.184 220.793 307.928C218.775 310.672 219.391 314.567 222.168 316.627Z"
                    fill="url(#paint32_radial_982_14494)"
                  />
                  <path
                    d="M224.399 313.591C225.479 314.392 226.99 314.176 227.775 313.109C228.559 312.041 228.32 310.527 227.24 309.725C226.16 308.924 224.648 309.14 223.864 310.207C223.08 311.275 223.319 312.789 224.399 313.591Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M209.047 287.629C211.824 289.689 215.71 289.134 217.728 286.389C219.745 283.645 219.129 279.75 216.352 277.69C213.576 275.63 209.689 276.185 207.672 278.929C205.654 281.673 206.27 285.569 209.047 287.629Z"
                    fill="url(#paint33_radial_982_14494)"
                  />
                  <path
                    d="M211.278 284.592C212.358 285.393 213.869 285.177 214.654 284.11C215.438 283.043 215.199 281.528 214.119 280.727C213.039 279.926 211.527 280.142 210.743 281.209C209.958 282.276 210.198 283.791 211.278 284.592Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M186.949 335.269C189.726 337.33 193.612 336.775 195.63 334.03C197.648 331.286 197.032 327.391 194.254 325.33C191.478 323.27 187.591 323.826 185.574 326.57C183.557 329.314 184.172 333.209 186.949 335.269Z"
                    fill="url(#paint34_radial_982_14494)"
                  />
                  <path
                    d="M189.18 332.233C190.26 333.034 191.771 332.818 192.556 331.751C193.341 330.683 193.101 329.169 192.021 328.367C190.941 327.566 189.43 327.782 188.645 328.849C187.861 329.917 188.1 331.431 189.18 332.233Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M173.828 391.195C176.605 393.256 180.491 392.701 182.509 389.956C184.526 387.212 183.91 383.316 181.133 381.256C178.357 379.196 174.47 379.752 172.453 382.496C170.436 385.24 171.051 389.135 173.828 391.195Z"
                    fill="url(#paint35_radial_982_14494)"
                  />
                  <path
                    d="M176.059 388.158C177.139 388.96 178.65 388.744 179.435 387.676C180.22 386.609 179.98 385.094 178.9 384.293C177.82 383.492 176.309 383.708 175.524 384.775C174.74 385.843 174.979 387.357 176.059 388.158Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M74.3826 282.796C77.1598 284.856 81.046 284.301 83.0636 281.556C85.0812 278.812 84.4651 274.917 81.688 272.857C78.9117 270.797 75.0246 271.352 73.0078 274.096C70.9903 276.84 71.6055 280.736 74.3826 282.796Z"
                    fill="url(#paint36_radial_982_14494)"
                  />
                  <path
                    d="M76.6136 279.759C77.6936 280.56 79.205 280.344 79.9896 279.277C80.7742 278.21 80.5346 276.695 79.4546 275.894C78.3749 275.093 76.8633 275.309 76.079 276.376C75.2944 277.443 75.5337 278.958 76.6136 279.759Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M76.4569 351.15C79.234 353.21 83.1202 352.655 85.1378 349.91C87.1554 347.166 86.5393 343.271 83.7622 341.211C80.9859 339.15 77.0988 339.706 75.082 342.45C73.0645 345.194 73.6798 349.089 76.4569 351.15Z"
                    fill="url(#paint37_radial_982_14494)"
                  />
                  <path
                    d="M78.6879 348.113C79.7679 348.914 81.2792 348.698 82.0638 347.631C82.8484 346.563 82.6088 345.049 81.5288 344.248C80.4492 343.446 78.9375 343.662 78.1532 344.73C77.3686 345.797 77.6079 347.312 78.6879 348.113Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M117.199 357.364C119.976 359.424 123.862 358.869 125.88 356.124C127.898 353.38 127.282 349.485 124.504 347.425C121.728 345.364 117.841 345.92 115.824 348.664C113.807 351.408 114.422 355.303 117.199 357.364Z"
                    fill="url(#paint38_radial_982_14494)"
                  />
                  <path
                    d="M119.43 354.327C120.51 355.128 122.021 354.912 122.806 353.845C123.591 352.777 123.351 351.263 122.271 350.462C121.191 349.66 119.68 349.876 118.895 350.944C118.111 352.011 118.35 353.526 119.43 354.327Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M106.152 397.409C108.929 399.469 112.816 398.915 114.833 396.17C116.851 393.426 116.235 389.53 113.458 387.47C110.681 385.41 106.794 385.966 104.777 388.71C102.76 391.454 103.375 395.349 106.152 397.409Z"
                    fill="url(#paint39_radial_982_14494)"
                  />
                  <path
                    d="M108.383 394.372C109.463 395.174 110.974 394.958 111.759 393.89C112.544 392.823 112.304 391.308 111.224 390.507C110.144 389.706 108.633 389.922 107.849 390.989C107.064 392.057 107.303 393.571 108.383 394.372Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M95.1014 437.455C97.8785 439.515 101.765 438.96 103.782 436.216C105.8 433.471 105.184 429.576 102.407 427.516C99.6304 425.456 95.7434 426.012 93.7266 428.756C91.709 431.5 92.3243 435.395 95.1014 437.455Z"
                    fill="url(#paint40_radial_982_14494)"
                  />
                  <path
                    d="M97.3324 434.418C98.4124 435.219 99.9237 435.004 100.708 433.936C101.493 432.869 101.253 431.354 100.173 430.553C99.0937 429.752 97.5821 429.968 96.7977 431.035C96.0131 432.102 96.2524 433.617 97.3324 434.418Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M107.531 485.096C110.308 487.156 114.194 486.601 116.212 483.856C118.23 481.112 117.614 477.217 114.836 475.157C112.06 473.097 108.173 473.652 106.156 476.396C104.139 479.14 104.754 483.036 107.531 485.096Z"
                    fill="url(#paint41_radial_982_14494)"
                  />
                  <path
                    d="M109.762 482.059C110.842 482.86 112.353 482.644 113.138 481.577C113.923 480.51 113.683 478.995 112.603 478.194C111.523 477.393 110.012 477.609 109.227 478.676C108.443 479.743 108.682 481.258 109.762 482.059Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M155.18 440.217C157.957 442.277 161.843 441.722 163.86 438.977C165.878 436.233 165.262 432.338 162.485 430.278C159.709 428.218 155.822 428.773 153.805 431.518C151.787 434.262 152.402 438.157 155.18 440.217Z"
                    fill="url(#paint42_radial_982_14494)"
                  />
                  <path
                    d="M157.411 437.18C158.491 437.981 160.002 437.766 160.786 436.698C161.571 435.631 161.331 434.116 160.252 433.315C159.172 432.514 157.66 432.73 156.876 433.797C156.091 434.864 156.331 436.379 157.411 437.18Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M144.133 397.409C146.91 399.469 150.796 398.915 152.814 396.17C154.831 393.426 154.215 389.53 151.438 387.47C148.662 385.41 144.775 385.966 142.758 388.71C140.74 391.454 141.356 395.349 144.133 397.409Z"
                    fill="url(#paint43_radial_982_14494)"
                  />
                  <path
                    d="M146.364 394.372C147.444 395.174 148.955 394.958 149.74 393.89C150.524 392.823 150.285 391.308 149.205 390.507C148.125 389.706 146.613 389.922 145.829 390.989C145.044 392.057 145.284 393.571 146.364 394.372Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M196.617 409.837C199.394 411.898 203.28 411.343 205.298 408.598C207.316 405.854 206.699 401.958 203.922 399.898C201.146 397.838 197.259 398.394 195.242 401.138C193.225 403.882 193.84 407.777 196.617 409.837Z"
                    fill="url(#paint44_radial_982_14494)"
                  />
                  <path
                    d="M198.848 406.801C199.928 407.602 201.439 407.386 202.224 406.318C203.009 405.251 202.769 403.736 201.689 402.935C200.609 402.134 199.098 402.35 198.313 403.417C197.529 404.485 197.768 405.999 198.848 406.801Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M177.277 469.216C180.054 471.276 183.941 470.721 185.958 467.976C187.976 465.232 187.36 461.337 184.583 459.277C181.806 457.216 177.919 457.772 175.902 460.516C173.885 463.26 174.5 467.155 177.277 469.216Z"
                    fill="url(#paint45_radial_982_14494)"
                  />
                  <path
                    d="M179.508 466.179C180.588 466.98 182.1 466.764 182.884 465.697C183.669 464.629 183.429 463.115 182.349 462.314C181.269 461.512 179.758 461.728 178.974 462.796C178.189 463.863 178.428 465.378 179.508 466.179Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M155.18 494.762C157.957 496.822 161.843 496.267 163.86 493.522C165.878 490.778 165.262 486.883 162.485 484.823C159.709 482.763 155.822 483.318 153.805 486.063C151.787 488.807 152.402 492.702 155.18 494.762Z"
                    fill="url(#paint46_radial_982_14494)"
                  />
                  <path
                    d="M157.411 491.725C158.491 492.526 160.002 492.311 160.786 491.243C161.571 490.176 161.331 488.661 160.252 487.86C159.172 487.059 157.66 487.275 156.876 488.342C156.091 489.409 156.331 490.924 157.411 491.725Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M196.617 505.119C199.394 507.179 203.28 506.624 205.298 503.879C207.316 501.135 206.699 497.24 203.922 495.18C201.146 493.12 197.259 493.675 195.242 496.419C193.225 499.163 193.84 503.059 196.617 505.119Z"
                    fill="url(#paint47_radial_982_14494)"
                  />
                  <path
                    d="M198.848 502.082C199.928 502.883 201.439 502.667 202.224 501.6C203.009 500.533 202.769 499.018 201.689 498.217C200.609 497.415 199.098 497.632 198.313 498.699C197.529 499.766 197.768 501.281 198.848 502.082Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M228.383 452.645C231.16 454.705 235.046 454.15 237.064 451.405C239.081 448.661 238.465 444.766 235.688 442.706C232.912 440.646 229.025 441.201 227.008 443.945C224.99 446.69 225.606 450.585 228.383 452.645Z"
                    fill="url(#paint48_radial_982_14494)"
                  />
                  <path
                    d="M230.614 449.608C231.694 450.409 233.205 450.193 233.99 449.126C234.774 448.059 234.535 446.544 233.455 445.743C232.375 444.942 230.863 445.158 230.079 446.225C229.294 447.292 229.534 448.807 230.614 449.608Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M218.715 394.648C221.492 396.708 225.378 396.153 227.396 393.408C229.413 390.664 228.797 386.769 226.02 384.709C223.244 382.648 219.357 383.204 217.34 385.948C215.322 388.692 215.938 392.588 218.715 394.648Z"
                    fill="url(#paint49_radial_982_14494)"
                  />
                  <path
                    d="M220.946 391.611C222.026 392.412 223.537 392.196 224.322 391.129C225.106 390.062 224.867 388.547 223.787 387.746C222.707 386.944 221.195 387.16 220.411 388.228C219.626 389.295 219.866 390.81 220.946 391.611Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M278.105 300.747C280.882 302.807 284.769 302.253 286.786 299.508C288.804 296.763 288.188 292.868 285.411 290.808C282.634 288.748 278.747 289.304 276.73 292.048C274.713 294.792 275.328 298.687 278.105 300.747Z"
                    fill="url(#paint50_radial_982_14494)"
                  />
                  <path
                    d="M280.336 297.71C281.416 298.512 282.928 298.296 283.712 297.228C284.497 296.161 284.257 294.646 283.177 293.845C282.098 293.044 280.586 293.26 279.802 294.327C279.017 295.394 279.256 296.909 280.336 297.71Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M291.918 335.96C294.695 338.02 298.581 337.465 300.599 334.72C302.616 331.976 302 328.081 299.223 326.021C296.447 323.961 292.56 324.516 290.543 327.26C288.525 330.005 289.141 333.9 291.918 335.96Z"
                    fill="url(#paint51_radial_982_14494)"
                  />
                  <path
                    d="M294.149 332.923C295.229 333.724 296.74 333.508 297.525 332.441C298.309 331.374 298.07 329.859 296.99 329.058C295.91 328.257 294.398 328.473 293.614 329.54C292.83 330.607 293.069 332.122 294.149 332.923Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M258.769 346.316C261.546 348.377 265.433 347.822 267.45 345.077C269.468 342.333 268.852 338.438 266.075 336.377C263.298 334.317 259.411 334.873 257.395 337.617C255.377 340.361 255.992 344.256 258.769 346.316Z"
                    fill="url(#paint52_radial_982_14494)"
                  />
                  <path
                    d="M261 343.28C262.08 344.081 263.592 343.865 264.376 342.798C265.161 341.73 264.921 340.216 263.841 339.414C262.762 338.613 261.25 338.829 260.466 339.896C259.681 340.964 259.92 342.478 261 343.28Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M278.105 407.076C280.882 409.136 284.769 408.581 286.786 405.836C288.804 403.092 288.188 399.197 285.411 397.137C282.634 395.076 278.747 395.632 276.73 398.376C274.713 401.12 275.328 405.015 278.105 407.076Z"
                    fill="url(#paint53_radial_982_14494)"
                  />
                  <path
                    d="M280.336 404.039C281.416 404.84 282.928 404.624 283.712 403.557C284.497 402.489 284.257 400.975 283.177 400.174C282.098 399.372 280.586 399.588 279.802 400.656C279.017 401.723 279.256 403.238 280.336 404.039Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M311.254 394.648C314.031 396.708 317.917 396.153 319.935 393.408C321.952 390.664 321.336 386.769 318.559 384.709C315.783 382.648 311.896 383.204 309.879 385.948C307.861 388.692 308.477 392.588 311.254 394.648Z"
                    fill="url(#paint54_radial_982_14494)"
                  />
                  <path
                    d="M313.485 391.611C314.565 392.412 316.076 392.196 316.861 391.129C317.645 390.062 317.406 388.547 316.326 387.746C315.246 386.944 313.734 387.16 312.95 388.228C312.165 389.295 312.405 390.81 313.485 391.611Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M342.328 413.29C345.105 415.35 348.991 414.795 351.009 412.05C353.026 409.306 352.41 405.411 349.633 403.351C346.857 401.29 342.97 401.846 340.953 404.59C338.936 407.334 339.551 411.229 342.328 413.29Z"
                    fill="url(#paint55_radial_982_14494)"
                  />
                  <path
                    d="M344.559 410.253C345.639 411.054 347.15 410.838 347.935 409.771C348.719 408.703 348.48 407.189 347.4 406.388C346.32 405.586 344.809 405.802 344.024 406.87C343.24 407.937 343.479 409.452 344.559 410.253Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M358.215 436.765C360.992 438.825 364.878 438.27 366.896 435.525C368.913 432.781 368.297 428.886 365.52 426.826C362.744 424.766 358.857 425.321 356.84 428.065C354.822 430.809 355.438 434.705 358.215 436.765Z"
                    fill="url(#paint56_radial_982_14494)"
                  />
                  <path
                    d="M360.446 433.728C361.526 434.529 363.037 434.313 363.822 433.246C364.606 432.179 364.367 430.664 363.287 429.863C362.207 429.061 360.695 429.278 359.911 430.345C359.126 431.412 359.366 432.927 360.446 433.728Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M385.144 329.746C387.921 331.806 391.808 331.251 393.825 328.506C395.843 325.762 395.227 321.867 392.45 319.807C389.673 317.747 385.786 318.302 383.77 321.046C381.752 323.791 382.367 327.686 385.144 329.746Z"
                    fill="url(#paint57_radial_982_14494)"
                  />
                  <path
                    d="M387.375 326.709C388.455 327.51 389.967 327.294 390.751 326.227C391.536 325.16 391.296 323.645 390.216 322.844C389.137 322.043 387.625 322.259 386.841 323.326C386.056 324.393 386.295 325.908 387.375 326.709Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M396.195 394.648C398.972 396.708 402.859 396.153 404.876 393.408C406.894 390.664 406.278 386.769 403.501 384.709C400.724 382.648 396.837 383.204 394.82 385.948C392.803 388.692 393.418 392.588 396.195 394.648Z"
                    fill="url(#paint58_radial_982_14494)"
                  />
                  <path
                    d="M398.426 391.611C399.506 392.412 401.017 392.196 401.802 391.129C402.587 390.062 402.347 388.547 401.267 387.746C400.187 386.944 398.676 387.16 397.891 388.228C397.107 389.295 397.346 390.81 398.426 391.611Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M364.426 388.434C367.203 390.494 371.089 389.939 373.107 387.194C375.124 384.45 374.508 380.555 371.731 378.495C368.955 376.434 365.068 376.99 363.051 379.734C361.033 382.478 361.649 386.373 364.426 388.434Z"
                    fill="url(#paint59_radial_982_14494)"
                  />
                  <path
                    d="M366.657 385.397C367.737 386.198 369.248 385.982 370.033 384.915C370.817 383.847 370.578 382.333 369.498 381.532C368.418 380.73 366.906 380.946 366.122 382.014C365.337 383.081 365.577 384.596 366.657 385.397Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M395.504 452.645C398.281 454.705 402.167 454.15 404.185 451.405C406.202 448.661 405.586 444.766 402.809 442.706C400.033 440.646 396.146 441.201 394.129 443.945C392.111 446.69 392.727 450.585 395.504 452.645Z"
                    fill="url(#paint60_radial_982_14494)"
                  />
                  <path
                    d="M397.735 449.608C398.815 450.409 400.326 450.193 401.111 449.126C401.895 448.059 401.656 446.544 400.576 445.743C399.496 444.942 397.984 445.158 397.2 446.225C396.415 447.292 396.655 448.807 397.735 449.608Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M426.582 516.856C429.359 518.916 433.245 518.362 435.263 515.617C437.28 512.872 436.664 508.977 433.887 506.917C431.111 504.857 427.224 505.413 425.207 508.157C423.189 510.901 423.805 514.796 426.582 516.856Z"
                    fill="url(#paint61_radial_982_14494)"
                  />
                  <path
                    d="M428.813 513.819C429.893 514.621 431.404 514.405 432.189 513.337C432.973 512.27 432.734 510.755 431.654 509.954C430.574 509.153 429.063 509.369 428.278 510.436C427.494 511.503 427.733 513.018 428.813 513.819Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M398.265 537.57C401.043 539.63 404.929 539.075 406.946 536.33C408.964 533.586 408.348 529.691 405.571 527.631C402.794 525.57 398.907 526.126 396.891 528.87C394.873 531.614 395.488 535.509 398.265 537.57Z"
                    fill="url(#paint62_radial_982_14494)"
                  />
                  <path
                    d="M400.496 534.533C401.576 535.334 403.088 535.118 403.872 534.051C404.657 532.983 404.417 531.469 403.337 530.668C402.258 529.866 400.746 530.082 399.962 531.15C399.177 532.217 399.416 533.732 400.496 534.533Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M380.312 504.428C383.089 506.488 386.976 505.934 388.993 503.189C391.011 500.445 390.395 496.549 387.618 494.489C384.841 492.429 380.954 492.985 378.938 495.729C376.92 498.473 377.535 502.368 380.312 504.428Z"
                    fill="url(#paint63_radial_982_14494)"
                  />
                  <path
                    d="M382.543 501.391C383.623 502.193 385.135 501.977 385.919 500.909C386.704 499.842 386.464 498.327 385.384 497.526C384.305 496.725 382.793 496.941 382.009 498.008C381.224 499.075 381.463 500.59 382.543 501.391Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M414.152 485.096C416.929 487.156 420.816 486.601 422.833 483.856C424.851 481.112 424.235 477.217 421.458 475.157C418.681 473.097 414.794 473.652 412.777 476.396C410.76 479.14 411.375 483.036 414.152 485.096Z"
                    fill="url(#paint64_radial_982_14494)"
                  />
                  <path
                    d="M416.383 482.059C417.463 482.86 418.974 482.644 419.759 481.577C420.544 480.51 420.304 478.995 419.224 478.194C418.144 477.393 416.633 477.609 415.849 478.676C415.064 479.743 415.303 481.258 416.383 482.059Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M311.254 254.487C314.031 256.547 317.917 255.993 319.935 253.248C321.952 250.504 321.336 246.608 318.559 244.548C315.783 242.488 311.896 243.044 309.879 245.788C307.861 248.532 308.477 252.427 311.254 254.487Z"
                    fill="url(#paint65_radial_982_14494)"
                  />
                  <path
                    d="M313.485 251.451C314.565 252.252 316.076 252.036 316.861 250.968C317.645 249.901 317.406 248.387 316.326 247.585C315.246 246.784 313.734 247 312.95 248.067C312.165 249.135 312.405 250.649 313.485 251.451Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M307.801 228.941C310.578 231.001 314.464 230.446 316.482 227.701C318.499 224.957 317.883 221.062 315.106 219.002C312.33 216.942 308.443 217.497 306.426 220.242C304.408 222.986 305.024 226.881 307.801 228.941Z"
                    fill="url(#paint66_radial_982_14494)"
                  />
                  <path
                    d="M310.032 225.904C311.112 226.705 312.623 226.49 313.408 225.422C314.192 224.355 313.953 222.84 312.873 222.039C311.793 221.238 310.281 221.454 309.497 222.521C308.712 223.588 308.952 225.103 310.032 225.904Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M285.703 169.563C288.48 171.623 292.366 171.068 294.384 168.323C296.401 165.579 295.785 161.684 293.008 159.624C290.232 157.564 286.345 158.119 284.328 160.863C282.311 163.608 282.926 167.503 285.703 169.563Z"
                    fill="url(#paint67_radial_982_14494)"
                  />
                  <path
                    d="M287.934 166.526C289.014 167.327 290.525 167.111 291.31 166.044C292.094 164.977 291.855 163.462 290.775 162.661C289.695 161.86 288.184 162.076 287.399 163.143C286.615 164.21 286.854 165.725 287.934 166.526Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M334.734 208.228C337.511 210.288 341.398 209.733 343.415 206.988C345.433 204.244 344.817 200.349 342.04 198.289C339.263 196.229 335.376 196.784 333.359 199.528C331.342 202.272 331.957 206.168 334.734 208.228Z"
                    fill="url(#paint68_radial_982_14494)"
                  />
                  <path
                    d="M336.965 205.191C338.045 205.992 339.557 205.776 340.341 204.709C341.126 203.642 340.886 202.127 339.806 201.326C338.727 200.525 337.215 200.741 336.431 201.808C335.646 202.875 335.885 204.39 336.965 205.191Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M347.164 244.821C349.941 246.881 353.827 246.327 355.845 243.582C357.862 240.837 357.246 236.942 354.469 234.882C351.693 232.822 347.806 233.378 345.789 236.122C343.772 238.866 344.387 242.761 347.164 244.821Z"
                    fill="url(#paint69_radial_982_14494)"
                  />
                  <path
                    d="M349.395 241.784C350.475 242.586 351.986 242.37 352.771 241.302C353.555 240.235 353.316 238.72 352.236 237.919C351.156 237.118 349.645 237.334 348.86 238.401C348.076 239.468 348.315 240.983 349.395 241.784Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M344.402 173.015C347.179 175.075 351.066 174.52 353.083 171.775C355.101 169.031 354.485 165.136 351.708 163.076C348.931 161.016 345.044 161.571 343.027 164.316C341.01 167.06 341.625 170.955 344.402 173.015Z"
                    fill="url(#paint70_radial_982_14494)"
                  />
                  <path
                    d="M346.633 169.978C347.713 170.779 349.224 170.564 350.009 169.496C350.794 168.429 350.554 166.914 349.474 166.113C348.394 165.312 346.883 165.528 346.099 166.595C345.314 167.662 345.553 169.177 346.633 169.978Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M390.672 175.777C393.449 177.837 397.335 177.282 399.353 174.537C401.37 171.793 400.754 167.898 397.977 165.838C395.201 163.778 391.314 164.333 389.297 167.077C387.279 169.821 387.895 173.717 390.672 175.777Z"
                    fill="url(#paint71_radial_982_14494)"
                  />
                  <path
                    d="M392.903 172.74C393.983 173.541 395.494 173.325 396.279 172.258C397.063 171.191 396.824 169.676 395.744 168.875C394.664 168.074 393.152 168.29 392.368 169.357C391.583 170.424 391.823 171.939 392.903 172.74Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M407.937 424.337C410.714 426.397 414.601 425.842 416.618 423.097C418.636 420.353 418.02 416.458 415.243 414.398C412.466 412.337 408.579 412.893 406.563 415.637C404.545 418.381 405.16 422.277 407.937 424.337Z"
                    fill="url(#paint72_radial_982_14494)"
                  />
                  <path
                    d="M410.168 421.3C411.248 422.101 412.76 421.885 413.544 420.818C414.329 419.751 414.089 418.236 413.009 417.435C411.93 416.633 410.418 416.849 409.634 417.917C408.849 418.984 409.088 420.499 410.168 421.3Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M367.883 416.051C370.66 418.112 374.546 417.557 376.564 414.812C378.581 412.068 377.965 408.172 375.188 406.112C372.412 404.052 368.525 404.608 366.508 407.352C364.49 410.096 365.106 413.991 367.883 416.051Z"
                    fill="url(#paint73_radial_982_14494)"
                  />
                  <path
                    d="M370.114 413.015C371.194 413.816 372.705 413.6 373.49 412.532C374.274 411.465 374.035 409.95 372.955 409.149C371.875 408.348 370.363 408.564 369.579 409.631C368.794 410.699 369.034 412.213 370.114 413.015Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M222.168 371.863C224.945 373.923 228.831 373.368 230.849 370.623C232.866 367.879 232.25 363.984 229.473 361.924C226.697 359.864 222.81 360.419 220.793 363.163C218.775 365.908 219.391 369.803 222.168 371.863Z"
                    fill="url(#paint74_radial_982_14494)"
                  />
                  <path
                    d="M224.399 368.826C225.479 369.627 226.99 369.411 227.775 368.344C228.559 367.277 228.32 365.762 227.24 364.961C226.16 364.16 224.648 364.376 223.864 365.443C223.08 366.51 223.319 368.025 224.399 368.826Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M137.918 188.895C140.695 190.955 144.581 190.401 146.599 187.656C148.616 184.912 148 181.016 145.223 178.956C142.447 176.896 138.56 177.452 136.543 180.196C134.525 182.94 135.141 186.835 137.918 188.895Z"
                    fill="url(#paint75_radial_982_14494)"
                  />
                  <path
                    d="M140.149 185.859C141.229 186.66 142.74 186.444 143.525 185.376C144.309 184.309 144.07 182.794 142.99 181.993C141.91 181.192 140.398 181.408 139.614 182.475C138.83 183.543 139.069 185.057 140.149 185.859Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M140.68 224.108C143.457 226.168 147.343 225.613 149.36 222.868C151.378 220.124 150.762 216.229 147.985 214.169C145.209 212.109 141.322 212.664 139.305 215.409C137.287 218.153 137.902 222.048 140.68 224.108Z"
                    fill="url(#paint76_radial_982_14494)"
                  />
                  <path
                    d="M142.911 221.071C143.991 221.872 145.502 221.657 146.286 220.589C147.071 219.522 146.831 218.007 145.752 217.206C144.672 216.405 143.16 216.621 142.376 217.688C141.591 218.755 141.831 220.27 142.911 221.071Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M20.5194 78.4242C23.2965 80.4844 27.1827 79.9296 29.2003 77.1847C31.2179 74.4405 30.6018 70.5453 27.8247 68.4852C25.0484 66.4251 21.1613 66.9806 19.1445 69.7248C17.127 72.469 17.7423 76.3641 20.5194 78.4242Z"
                    fill="url(#paint77_radial_982_14494)"
                  />
                  <path
                    d="M22.7504 75.3874C23.8304 76.1886 25.3417 75.9729 26.1263 74.9054C26.9109 73.8382 26.6713 72.3234 25.5913 71.5222C24.5117 70.7211 23 70.9371 22.2157 72.0043C21.4311 73.0715 21.6704 74.5863 22.7504 75.3874Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M125.488 139.183C128.265 141.243 132.151 140.689 134.169 137.944C136.187 135.2 135.571 131.304 132.793 129.244C130.017 127.184 126.13 127.74 124.113 130.484C122.096 133.228 122.711 137.123 125.488 139.183Z"
                    fill="url(#paint78_radial_982_14494)"
                  />
                  <path
                    d="M127.719 136.146C128.799 136.948 130.31 136.732 131.095 135.664C131.88 134.597 131.64 133.082 130.56 132.281C129.48 131.48 127.969 131.696 127.184 132.763C126.4 133.831 126.639 135.345 127.719 136.146Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M86.1209 119.851C88.898 121.911 92.7843 121.356 94.8019 118.611C96.8194 115.867 96.2034 111.972 93.4263 109.912C90.6499 107.852 86.7629 108.407 84.7461 111.151C82.7285 113.896 83.3438 117.791 86.1209 119.851Z"
                    fill="url(#paint79_radial_982_14494)"
                  />
                  <path
                    d="M88.3519 116.814C89.4319 117.615 90.9432 117.399 91.7279 116.332C92.5125 115.265 92.2729 113.75 91.1929 112.949C90.1132 112.148 88.6016 112.364 87.8173 113.431C87.0327 114.498 87.2719 116.013 88.3519 116.814Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M95.1014 85.3287C97.8785 87.3888 101.765 86.8341 103.782 84.0891C105.8 81.3449 105.184 77.4497 102.407 75.3896C99.6304 73.3295 95.7434 73.885 93.7266 76.6292C91.709 79.3734 92.3243 83.2685 95.1014 85.3287Z"
                    fill="url(#paint80_radial_982_14494)"
                  />
                  <path
                    d="M97.3324 82.2919C98.4124 83.093 99.9237 82.8773 100.708 81.8098C101.493 80.7426 101.253 79.2278 100.173 78.4267C99.0937 77.6255 97.5821 77.8415 96.7977 78.9087C96.0131 79.9759 96.2524 81.4907 97.3324 82.2919Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M53.7085 228.25C58.0284 231.454 64.0738 230.591 67.2122 226.321C70.3506 222.053 69.3923 215.993 65.0724 212.789C60.7536 209.584 54.7071 210.448 51.5699 214.717C48.4315 218.986 49.3886 225.045 53.7085 228.25Z"
                    fill="url(#paint81_radial_982_14494)"
                  />
                  <path
                    d="M57.1829 223.526C58.8628 224.772 61.2138 224.436 62.4343 222.776C63.6548 221.116 63.2821 218.759 61.6022 217.513C59.9226 216.267 57.5712 216.603 56.3512 218.263C55.1307 219.923 55.5029 222.279 57.1829 223.526Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M86.8569 329.054C91.1769 332.259 97.2222 331.396 100.361 327.126C103.499 322.857 102.541 316.798 98.2208 313.594C93.9021 310.389 87.8556 311.253 84.7183 315.522C81.5799 319.791 82.537 325.85 86.8569 329.054Z"
                    fill="url(#paint82_radial_982_14494)"
                  />
                  <path
                    d="M90.3313 324.33C92.0113 325.577 94.3622 325.241 95.5827 323.581C96.8032 321.921 96.4306 319.564 94.7506 318.318C93.0711 317.072 90.7197 317.408 89.4996 319.068C88.2791 320.728 88.6513 323.084 90.3313 324.33Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M120.001 429.859C124.321 433.064 130.367 432.201 133.505 427.931C136.644 423.662 135.685 417.603 131.365 414.398C127.047 411.194 121 412.058 117.863 416.327C114.724 420.595 115.682 426.655 120.001 429.859Z"
                    fill="url(#paint83_radial_982_14494)"
                  />
                  <path
                    d="M123.476 425.135C125.156 426.381 127.507 426.046 128.727 424.385C129.948 422.725 129.575 420.369 127.895 419.123C126.216 417.876 123.864 418.213 122.644 419.873C121.424 421.533 121.796 423.889 123.476 425.135Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M200.802 449.192C205.122 452.396 211.168 451.533 214.306 447.263C217.444 442.995 216.486 436.936 212.166 433.731C207.847 430.526 201.801 431.39 198.664 435.659C195.525 439.928 196.482 445.987 200.802 449.192Z"
                    fill="url(#paint84_radial_982_14494)"
                  />
                  <path
                    d="M204.277 444.468C205.957 445.714 208.308 445.378 209.528 443.718C210.749 442.058 210.376 439.701 208.696 438.455C207.016 437.209 204.665 437.545 203.445 439.205C202.224 440.865 202.597 443.221 204.277 444.468Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M253.287 468.524C257.607 471.729 263.652 470.866 266.79 466.596C269.929 462.327 268.97 456.268 264.651 453.063C260.332 449.859 254.285 450.723 251.148 454.992C248.01 459.26 248.967 465.32 253.287 468.524Z"
                    fill="url(#paint85_radial_982_14494)"
                  />
                  <path
                    d="M256.761 463.8C258.441 465.046 260.792 464.711 262.012 463.05C263.233 461.39 262.86 459.034 261.18 457.788C259.501 456.541 257.149 456.877 255.929 458.538C254.709 460.198 255.081 462.554 256.761 463.8Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M175.251 371.862C179.571 375.067 185.617 374.204 188.755 369.934C191.894 365.665 190.935 359.606 186.615 356.401C182.297 353.197 176.25 354.061 173.113 358.329C169.974 362.598 170.932 368.657 175.251 371.862Z"
                    fill="url(#paint86_radial_982_14494)"
                  />
                  <path
                    d="M178.726 367.138C180.406 368.384 182.757 368.049 183.977 366.388C185.198 364.728 184.825 362.372 183.145 361.126C181.466 359.879 179.114 360.215 177.894 361.875C176.674 363.535 177.046 365.892 178.726 367.138Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M113.791 247.582C118.11 250.787 124.156 249.924 127.294 245.654C130.433 241.385 129.474 235.326 125.154 232.121C120.836 228.917 114.789 229.781 111.652 234.05C108.514 238.318 109.471 244.377 113.791 247.582Z"
                    fill="url(#paint87_radial_982_14494)"
                  />
                  <path
                    d="M117.265 242.858C118.945 244.104 121.296 243.769 122.516 242.108C123.737 240.448 123.364 238.092 121.684 236.846C120.005 235.599 117.653 235.935 116.433 237.595C115.213 239.255 115.585 241.612 117.265 242.858Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M63.3765 103.97C67.6964 107.174 73.7417 106.311 76.8802 102.041C80.0186 97.7727 79.0603 91.7135 74.7404 88.5089C70.4216 85.3043 64.3751 86.1684 61.2379 90.4372C58.0994 94.7059 59.0565 100.765 63.3765 103.97Z"
                    fill="url(#paint88_radial_982_14494)"
                  />
                  <path
                    d="M66.8508 99.2456C68.5308 100.492 70.8818 100.156 72.1023 98.4957C73.3228 96.8357 72.9501 94.4794 71.2701 93.2331C69.5906 91.9869 67.2392 92.3229 66.0192 93.983C64.7987 95.643 65.1709 97.9994 66.8508 99.2456Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M181.039 319.094C189.752 325.559 201.945 323.818 208.275 315.204C214.605 306.593 212.672 294.37 203.959 287.905C195.249 281.44 183.053 283.183 176.726 291.795C170.396 300.406 172.326 312.63 181.039 319.094Z"
                    fill="url(#paint89_radial_982_14494)"
                  />
                  <path
                    data-location="Dhaka"
                    classNameName="loc"
                    d="M188.044 309.564C191.433 312.079 196.174 311.402 198.636 308.052C201.098 304.703 200.346 299.949 196.958 297.435C193.57 294.921 188.828 295.599 186.367 298.948C183.905 302.297 184.656 307.05 188.044 309.564Z"
                    fill="#D3ECE3"
                    onClick={(e) => setOpenModal(true)}
                  />
                  <path
                    d="M213.923 231.702C218.243 234.906 224.289 234.044 227.427 229.774C230.565 225.505 229.607 219.446 225.287 216.241C220.968 213.036 214.922 213.901 211.785 218.169C208.646 222.438 209.603 228.497 213.923 231.702Z"
                    fill="url(#paint90_radial_982_14494)"
                  />
                  <path
                    d="M217.398 226.978C219.078 228.224 221.429 227.888 222.649 226.228C223.87 224.568 223.497 222.212 221.817 220.965C220.137 219.719 217.786 220.055 216.566 221.715C215.346 223.375 215.718 225.732 217.398 226.978Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M181.466 172.324C185.786 175.528 191.832 174.665 194.97 170.395C198.108 166.127 197.15 160.068 192.83 156.863C188.511 153.658 182.465 154.522 179.328 158.791C176.189 163.06 177.146 169.119 181.466 172.324Z"
                    fill="url(#paint91_radial_982_14494)"
                  />
                  <path
                    d="M184.941 167.6C186.621 168.846 188.972 168.51 190.192 166.85C191.413 165.19 191.04 162.833 189.36 161.587C187.68 160.341 185.329 160.677 184.109 162.337C182.888 163.997 183.261 166.353 184.941 167.6Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M305.771 191.656C310.091 194.861 316.136 193.998 319.275 189.728C322.413 185.459 321.455 179.4 317.135 176.195C312.816 172.991 306.77 173.855 303.632 178.124C300.494 182.392 301.451 188.451 305.771 191.656Z"
                    fill="url(#paint92_radial_982_14494)"
                  />
                  <path
                    d="M309.245 186.932C310.925 188.178 313.276 187.843 314.497 186.182C315.717 184.522 315.345 182.166 313.665 180.92C311.985 179.673 309.634 180.009 308.414 181.669C307.193 183.329 307.565 185.686 309.245 186.932Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M365.849 210.988C370.169 214.193 376.214 213.33 379.353 209.06C382.491 204.791 381.533 198.732 377.213 195.528C372.894 192.323 366.848 193.187 363.711 197.456C360.572 201.725 361.529 207.784 365.849 210.988Z"
                    fill="url(#paint93_radial_982_14494)"
                  />
                  <path
                    d="M369.323 206.264C371.003 207.511 373.354 207.175 374.575 205.515C375.795 203.854 375.423 201.498 373.743 200.252C372.063 199.006 369.712 199.342 368.492 201.002C367.271 202.662 367.644 205.018 369.323 206.264Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M296.103 279.342C300.423 282.547 306.468 281.684 309.607 277.414C312.745 273.145 311.787 267.086 307.467 263.882C303.148 260.677 297.102 261.541 293.964 265.81C290.826 270.079 291.783 276.138 296.103 279.342Z"
                    fill="url(#paint94_radial_982_14494)"
                  />
                  <path
                    d="M299.577 274.618C301.257 275.865 303.608 275.529 304.829 273.869C306.049 272.208 305.677 269.852 303.997 268.606C302.317 267.36 299.966 267.696 298.746 269.356C297.525 271.016 297.897 273.372 299.577 274.618Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M272.623 371.862C276.943 375.067 282.988 374.204 286.126 369.934C289.265 365.665 288.306 359.606 283.986 356.401C279.668 353.197 273.621 354.061 270.484 358.329C267.346 362.598 268.303 368.657 272.623 371.862Z"
                    fill="url(#paint95_radial_982_14494)"
                  />
                  <path
                    d="M276.097 367.138C277.777 368.384 280.128 368.049 281.348 366.388C282.569 364.728 282.196 362.372 280.516 361.126C278.837 359.879 276.485 360.215 275.265 361.875C274.045 363.535 274.417 365.892 276.097 367.138Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M379.666 367.029C383.985 370.233 390.031 369.371 393.169 365.101C396.308 360.832 395.349 354.773 391.029 351.568C386.711 348.363 380.664 349.228 377.527 353.496C374.389 357.765 375.346 363.824 379.666 367.029Z"
                    fill="url(#paint96_radial_982_14494)"
                  />
                  <path
                    d="M383.14 362.305C384.82 363.551 387.171 363.215 388.391 361.555C389.612 359.895 389.239 357.539 387.559 356.292C385.88 355.046 383.528 355.382 382.308 357.042C381.088 358.702 381.46 361.059 383.14 362.305Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M378.283 481.643C382.603 484.847 388.648 483.984 391.786 479.714C394.925 475.446 393.967 469.386 389.647 466.182C385.328 462.977 379.281 463.841 376.144 468.11C373.006 472.379 373.963 478.438 378.283 481.643Z"
                    fill="url(#paint97_radial_982_14494)"
                  />
                  <path
                    d="M381.757 476.919C383.437 478.165 385.788 477.829 387.009 476.169C388.229 474.509 387.856 472.152 386.176 470.906C384.497 469.66 382.145 469.996 380.925 471.656C379.705 473.316 380.077 475.672 381.757 476.919Z"
                    fill="#D3ECE3"
                  />
                  <path
                    d="M386.568 572.781C390.888 575.986 396.933 575.123 400.072 570.853C403.21 566.584 402.252 560.525 397.932 557.32C393.613 554.116 387.567 554.98 384.429 559.249C381.291 563.517 382.248 569.576 386.568 572.781Z"
                    fill="url(#paint98_radial_982_14494)"
                  />
                  <path
                    d="M390.042 568.057C391.722 569.303 394.073 568.968 395.294 567.307C396.514 565.647 396.142 563.291 394.462 562.045C392.782 560.798 390.431 561.134 389.211 562.795C387.99 564.455 388.362 566.811 390.042 568.057Z"
                    fill="#D3ECE3"
                  />
                </g>
                <defs>
                  <linearGradient
                    id="paint0_linear_982_14494"
                    x1="46.7838"
                    y1="1.64856"
                    x2="543.397"
                    y2="59.3616"
                    gradientUnits="userSpaceOnUse"
                  >
                    <stop stop-color="#3CDD97" />
                    <stop offset="1" stop-color="#00FF94" />
                  </linearGradient>
                  <linearGradient
                    id="paint1_linear_982_14494"
                    x1="46.8421"
                    y1="1.64856"
                    x2="543.453"
                    y2="59.3555"
                    gradientUnits="userSpaceOnUse"
                  >
                    <stop stop-color="#3CDD97" />
                    <stop offset="1" stop-color="#00FF94" />
                  </linearGradient>
                  <linearGradient
                    id="paint2_linear_982_14494"
                    x1="235.769"
                    y1="341.402"
                    x2="360.881"
                    y2="355.659"
                    gradientUnits="userSpaceOnUse"
                  >
                    <stop stop-color="#3CDD97" />
                    <stop offset="1" stop-color="#00FF94" />
                  </linearGradient>
                  <linearGradient
                    id="paint3_linear_982_14494"
                    x1="77.2596"
                    y1="256.835"
                    x2="207.125"
                    y2="270.513"
                    gradientUnits="userSpaceOnUse"
                  >
                    <stop stop-color="#3CDD97" />
                    <stop offset="1" stop-color="#00FF94" />
                  </linearGradient>
                  <linearGradient
                    id="paint4_linear_982_14494"
                    x1="140.383"
                    y1="195.776"
                    x2="342.45"
                    y2="225.605"
                    gradientUnits="userSpaceOnUse"
                  >
                    <stop stop-color="#3CDD97" />
                    <stop offset="1" stop-color="#00FF94" />
                  </linearGradient>
                  <linearGradient
                    id="paint5_linear_982_14494"
                    x1="114.231"
                    y1="128.111"
                    x2="323.06"
                    y2="204.798"
                    gradientUnits="userSpaceOnUse"
                  >
                    <stop stop-color="#3CDD97" />
                    <stop offset="1" stop-color="#00FF94" />
                  </linearGradient>
                  <radialGradient
                    id="paint6_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(130.52 102.453) rotate(135.006) scale(9.11438 9.25233)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint7_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(40.0549 57.5745) rotate(135.006) scale(9.11437 9.25233)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint8_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(55.9379 26.5046) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint9_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(72.5122 51.3606) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint10_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(102.207 57.5746) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint11_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(55.9379 79.6688) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint12_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(64.9145 174.26) rotate(135.006) scale(5.85923 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint13_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(156.762 80.3593) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint14_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(141.571 161.141) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint15_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(17.9536 204.639) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint16_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(92.5356 203.258) rotate(135.006) scale(5.85923 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint17_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(120.852 271.612) rotate(135.006) scale(5.85923 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint18_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(165.047 183.926) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint19_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(216.153 189.449) rotate(135.006) scale(5.85923 5.94791)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint20_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(249.301 173.569) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint21_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(262.422 208.091) rotate(135.006) scale(5.85923 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint22_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(275.543 242.614) rotate(135.006) scale(5.85924 5.94793)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint23_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(255.516 277.826) rotate(135.006) scale(5.85923 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint24_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(229.965 261.946) rotate(135.006) scale(5.85923 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint25_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(203.032 255.042) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint26_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(184.387 219.139) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint27_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(174.719 242.614) rotate(135.006) scale(5.85923 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint28_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(163.668 290.254) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint29_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(135.352 304.754) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint30_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(162.286 337.204) rotate(135.006) scale(5.85925 5.94793)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint31_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(206.485 349.632) rotate(135.006) scale(5.85923 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint32_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(225.821 311.658) rotate(135.006) scale(5.85923 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint33_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(212.7 282.659) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint34_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(190.602 330.3) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint35_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(177.481 386.226) rotate(135.006) scale(5.85925 5.94793)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint36_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(78.0356 277.826) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint37_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(80.1098 346.18) rotate(135.006) scale(5.85924 5.94793)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint38_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(120.852 352.394) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint39_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(109.805 392.44) rotate(135.006) scale(5.85924 5.94793)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint40_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(98.7543 432.486) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint41_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(111.184 480.126) rotate(135.006) scale(5.85925 5.94793)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint42_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(158.832 435.248) rotate(135.006) scale(5.85925 5.94793)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint43_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(147.786 392.44) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint44_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(200.27 404.868) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint45_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(180.93 464.246) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint46_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(158.832 489.793) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint47_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(200.27 500.149) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint48_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(232.036 447.676) rotate(135.006) scale(5.85923 5.94791)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint49_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(222.368 389.678) rotate(135.006) scale(5.85924 5.94793)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint50_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(281.758 295.778) rotate(135.006) scale(5.85923 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint51_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(295.571 330.99) rotate(135.006) scale(5.85923 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint52_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(262.422 341.347) rotate(135.006) scale(5.85923 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint53_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(281.758 402.106) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint54_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(314.907 389.678) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint55_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(345.981 408.32) rotate(135.006) scale(5.85922 5.9479)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint56_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(361.868 431.795) rotate(135.006) scale(5.85925 5.94794)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint57_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(388.797 324.776) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint58_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(399.848 389.678) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint59_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(368.079 383.464) rotate(135.006) scale(5.85925 5.94793)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint60_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(399.157 447.676) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint61_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(430.235 511.887) rotate(135.006) scale(5.85922 5.9479)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint62_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(401.918 532.6) rotate(135.006) scale(5.85923 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint63_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(383.965 499.459) rotate(135.006) scale(5.85925 5.94793)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint64_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(417.805 480.126) rotate(135.006) scale(5.85925 5.94793)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint65_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(314.907 249.518) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint66_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(311.454 223.972) rotate(135.006) scale(5.85924 5.94793)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint67_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(289.356 164.593) rotate(135.006) scale(5.85923 5.94791)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint68_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(338.387 203.258) rotate(135.006) scale(5.85925 5.94793)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint69_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(350.817 239.852) rotate(135.006) scale(5.85923 5.94791)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint70_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(348.055 168.046) rotate(135.006) scale(5.85923 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint71_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(394.325 170.807) rotate(135.006) scale(5.85923 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint72_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(411.59 419.367) rotate(135.006) scale(5.85925 5.94793)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint73_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(371.536 411.082) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint74_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(225.821 366.894) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint75_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(141.571 183.926) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint76_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(144.332 219.139) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint77_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(24.1723 73.4548) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint78_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(129.141 134.214) rotate(135.006) scale(5.85924 5.94792)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint79_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(89.7739 114.881) rotate(135.006) scale(5.85924 5.94793)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint80_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(98.7543 80.3593) rotate(135.006) scale(5.85924 5.94793)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint81_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(59.3909 220.519) rotate(135.006) scale(9.11437 9.25233)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint82_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(92.5393 321.324) rotate(135.006) scale(9.11437 9.25233)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint83_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(125.684 422.129) rotate(135.006) scale(9.11437 9.25232)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint84_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(206.485 441.462) rotate(135.006) scale(9.11438 9.25234)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint85_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(258.969 460.794) rotate(135.006) scale(9.11436 9.25231)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint86_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(180.934 364.132) rotate(135.006) scale(9.11438 9.25233)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint87_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(119.473 239.852) rotate(135.006) scale(9.11437 9.25232)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint88_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(69.0588 96.2394) rotate(135.006) scale(9.11437 9.25232)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint89_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(192.5 303.5) rotate(135) scale(18.3849 18.6631)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint90_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(219.606 223.972) rotate(135.006) scale(9.11437 9.25233)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint91_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(187.149 164.593) rotate(135.006) scale(9.11437 9.25233)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint92_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(311.453 183.926) rotate(135.006) scale(9.11437 9.25233)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint93_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(371.531 203.258) rotate(135.006) scale(9.11437 9.25232)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint94_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(301.785 271.612) rotate(135.006) scale(9.11437 9.25232)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint95_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(278.305 364.132) rotate(135.006) scale(9.11438 9.25234)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint96_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(385.348 359.299) rotate(135.006) scale(9.11436 9.25231)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint97_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(383.965 473.912) rotate(135.006) scale(9.11438 9.25233)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <radialGradient
                    id="paint98_radial_982_14494"
                    cx="0"
                    cy="0"
                    r="1"
                    gradientUnits="userSpaceOnUse"
                    gradientTransform="translate(392.25 565.051) rotate(135.006) scale(9.11437 9.25232)"
                  >
                    <stop stop-color="#20E58F" />
                    <stop offset="1" stop-color="#20E58F" stop-opacity="0" />
                  </radialGradient>
                  <clipPath id="clip0_982_14494">
                    <rect width="445" height="624" fill="white" />
                  </clipPath>
                </defs>
              </svg>
            </div>
          </div>
          {/* rightcol */}

          <div>
            <h1 className="my-24 text-center text-3xl font-bold uppercase text-white lg:text-left lg:text-[50px]">
              {highlightTitleInDescription(data.description, data.title)}
            </h1>
            <div className="grid h-1/2 grid-cols-1 gap-10 md:grid-cols-2 lg:gap-5">
              <div className="item flex items-center justify-center gap-5 text-white">
                <div className="rounded-full border border-green-800 p-4">
                  <Image src={popicon} alt="" className="h-12 w-12" />
                </div>

                <div className="w-36">
                  <h1 className="pb-5 text-5xl font-bold">942+</h1>
                  <span>pop</span>
                </div>
              </div>

              <div className="item flex items-center justify-center gap-5 text-white">
                <div className="rounded-full border border-green-800 p-4">
                  <Image src={regional} alt="" className="h-12 w-12" />
                </div>

                <div className="w-36">
                  <h1 className="pb-5 text-5xl font-bold">9</h1>
                  <span>Regional Hubs</span>
                </div>
              </div>

              <div className="item flex items-center justify-center gap-5 text-white">
                <div className="rounded-full border border-green-800 p-4">
                  <Image src={location} alt="" className="h-12 w-12" />
                </div>

                <div className="w-36">
                  <h1 className="pb-5 text-5xl font-bold">61</h1>
                  <span>Districts</span>
                </div>
              </div>

              <div className="item flex items-center justify-center gap-5 text-white">
                <div className="rounded-full border border-green-800 p-4">
                  <Image src={location} alt="" className="h-12 w-12" />
                </div>

                <div className="w-36">
                  <h1 className="pb-5 text-5xl font-bold">377+</h1>
                  <span>Number of Upazilas</span>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>

      <Modal show={openModal} onClose={() => setOpenModal(false)} className="mt-12">
        <Modal.Header>ADN TELECOM LTD.</Modal.Header>
        <Modal.Body>
          <MyGoogleMap />
        </Modal.Body>
      </Modal>
    </section>
  );
};

export default Map;
