import { BsArrowUpRight, BsArrowUpRightCircle } from "react-icons/bs";

export function LinkBtn({text, url}) {
  return <a href={url} className="group-hover:border-black group-hover:text-black py-4 px-5 border-[3px] border-primary rounded-xl text-primary font-sans inline-flex gap-3 items-center hover:border-transparent hover:bg-primary hover:text-black group-hover:hover:border-transparent group-hover:hover:bg-black group-hover:hover:text-primary">
    <div>{text ?? "Click here"}</div>
    <BsArrowUpRightCircle size="20px"/>
  </a>
}