import Container from "@/app/component/Container";
import { IconCard } from "@/app/component/IconCard";

const lsps = [
  {
    title: 'Internet Service Provider (ISP) Operator License (Nationwide)',
    image: '/assets/images/p-1.jpeg',
    icon: '/assets/images/wifi.svg'
  },
  {
    title: 'Internet Protocol Telephony Service Provider License (Nationwide IPTSP)',
    image: '/assets/images/p-2.jpeg',
    icon: '/assets/images/connect.svg'
  },
  {
    title: 'VSAT Hub Operator License',
    image: '/assets/images/p-3.jpeg',
    icon: '/assets/images/connect-peoples.svg'
  },
  {
    title: 'Frequency 5.4 GHz, 10.5 GHz &amp; 18 GHz License',
    image: '/assets/images/p-4.jpeg',
    icon: '/assets/images/computer.svg'
  },
  {
    title: '2.4 &amp; 5.7 GHz (ISM) Band Frequency Permission',
    image: '/assets/images/p-5.jpeg',
    icon: '/assets/images/radio.svg'
  },
  {
    title: 'BTRC Permission for Google Cache Server',
    image: '/assets/images/p-6.jpeg',
    icon: '/assets/images/door-open.svg'
  },
  {
    title: 'BTRC Permission for Video on Demand (VoD)/ Streaming Service',
    image: '/assets/images/p-7.jpeg',
    icon: '/assets/images/tunnel.svg'
  },
  {
    title: 'BTRC Permission for ADN WiFi Service in Partnership with Other ISPs',
    image: '/assets/images/p-8.jpeg',
    icon: '/assets/images/wifi.svg'
  },
  {
    title: 'BTRC Permission for ADN WiFi Service in Partnership with Other ISPs',
    image: '/assets/images/p-9.jpeg',
    icon: '/assets/images/wave.svg'
  },
]

export function Licenses() {
  return  <Container>
    <section id="license" className="mx-5 md:mx-10 2xl:mx-0">
      <h1 className="text-h1">Licenses</h1>
      <p className="text-sub-h1">
        <span className="text-primary">Licenses, Certificates</span> &
        Permissions
      </p>

      <div className="grid lg:grid-cols-3 gap-6 my-8 lg:mt-16">
        {lsps.map((value, index) => <IconCard key={index} {...value} />)}
      </div>
    </section>
  </Container>

}
