import Container from "@/app/component/Container";
import Image from "next/image";
import { ImageCard2 } from "@/app/component/ImageCard2";
import Slider from "@/app/component/Slider";

const investors = [
  {
    image: '/assets/images/dse.png',
    description: 'The Dhaka Stock Exchange, located in Nikunja, Dhaka, is one of the two stock exchanges of Bangladesh, the other being the Chittagong Stock Exchange. In January 2023, DSE and Nasdaq announced their partnership with trading technology',
    url: '#',
  },
  {
    image: '/assets/images/cse.png',
    description: 'It is one of the twin financial hubs of the country, alongside the Dhaka Stock Exchange. Established in 1995, the exchange is located in the Agrabad business district in downtown Chittagong. It has a combined market capitalization of over US$ 38 billion as of 2020..',
    url: "#"
  },
  {
    image: '/assets/images/bsec.png',
    description: 'BSEC was established on 8 June 1993 under the Securities and Exchange Commission Act, 1993. Sultan-uz Zaman Khan, a career bureaucrat, was the first commissioner of the commission. Before the commission, the market were regulated under the Capital Issues Act 1947.',
    url: "#"
  },
]

export function Investor() {
  return <section id="investor">
    <Container>
      <div id="#partners" className="mx-5 md:mx-10 2xl:mx-0">
        <h1 className="text-h1">Investor</h1>
        <p className="text-h2 lg:-mt-8">
          <span className="text-primary">Investor</span> Segment
        </p>
      </div>
    </Container>
    <div className="mt-6 md:mt-12">
      <Slider></Slider>
    </div>
    <Container>
      <div className="mx-5 md:mx-10 2xl:mx-0">
        <div className="space-y-8 my-12 2xl:my-24">
          {investors.map((p, i) => <ImageCard2 {...p} key="i"/>)}
        </div>
      </div>
    </Container>
  </section>
}
