import Image from "next/image";
import { LinkBtn } from "@/app/component/LinkBtn";

export function ImageCard2({image, description, url}) {
  return <div className="group bg-secondary hover:bg-primary py-6 px-7 md:px-14 *:transition-all duration-500 flex flex-col md:flex-row gap-8 items-center">
    <Image className="block my-8 md:my-0 w-56  md:w-44 h-65 md:h-44 object-contain" src={image} width="200" height="200" alt=""></Image>
    <div>
      <p className="text-body group-hover:text-black">{description}</p>
      {url && <div class="mt-5">
        <LinkBtn url="url" text="Learn more"/>
      </div>}
    </div>
  </div>
}

