import Image from "next/image";

export function ImageCard({title, image, icon}) {
  return (
    <div className="relative w-full">
      <div className="bg-white">
        <Image
          src={image}
          class="w-full h-60 xl:h-72 cover"
          alt=""
          width="600"
          height="600"
        ></Image>
        <div className="p-5 h-24 overflow-hidden">
          <h5 className="text-h5 text-black line-clamp-2">{title}</h5>
        </div>
      </div>
      {icon && <div className="absolute top-4 left-4 rounded-full p-2 bg-primary-light">
        <Image className="h-8 w-8 object-contain" src={icon} width="128" height="128" alt=""></Image>
      </div>}
    </div>
  );
}
