import Image from "next/image";

export function IconCard({icon, title}) {
  return <div className="bg-secondary p-12">
    <div className="rounded-full p-2 bg-primary-light inline-block">
      <Image className="h-8 w-8 object-contain" src={icon} width="128" height="128" alt=""></Image>
    </div>
    <h5 className="text-h5 italic border-b py-9 border-b-primary">{title}</h5>
  </div>
}

