"use client";

import { Button, Drawer, Sidebar, TextInput } from "flowbite-react";
import { useState } from "react";
import {
  HiChartPie,
  HiClipboard,
  HiCollection,
  HiInformationCircle,
  HiLogin,
  HiPencil,
  HiSearch,
  HiShoppingBag,
  HiUsers,
} from "react-icons/hi";
import { useRouter } from "next/navigation";

export function RightDrawer({ setIsOpen, isOpen, handleClose, data }) {
  const router = useRouter();

  const handleItemClick = (href) => {
    console.log(href);
    router.push(href, undefined, { scroll: false });
  };

  return (
    <>
      <Drawer
        open={isOpen}
        onClose={handleClose}
        position="right"
        className="bg-[#034D57]"
      >
        <Drawer.Header title="Hotline: 16615" titleIcon={() => <></>} />
        <Drawer.Items>
          <Sidebar
            aria-label="Sidebar with multi-level dropdown example"
            className="[&>div]:bg-transparent [&>div]:p-0"
          >
            <div className="flex h-full flex-col justify-between py-2">
              <div>
                <form className="pb-3 md:hidden">
                  <TextInput
                    icon={HiSearch}
                    type="search"
                    placeholder="Search"
                    required
                    size={32}
                  />
                </form>
                <Sidebar.Items>
                  <Sidebar.ItemGroup>
                    <div className="lg:hidden">
                      {data?.map((item) => (
                        <>
                          <Sidebar.Item
                            icon={HiChartPie}
                            className="text-white hover:text-black"
                            onClick={() => handleItemClick(item.path)}
                          >
                            {item?.title}
                          </Sidebar.Item>
                        </>
                      ))}
                    </div>
                  </Sidebar.ItemGroup>
                  <Sidebar.ItemGroup className="lg:border-none">
                    <Sidebar.Item
                      href="/coverage"
                      icon={HiClipboard}
                      className="text-white hover:text-black"
                    >
                      Coverage
                    </Sidebar.Item>
                    <Sidebar.Item
                      href="#"
                      icon={HiCollection}
                      className="text-white hover:text-black"
                    >
                      Netwok Coverage
                    </Sidebar.Item>
                    <Sidebar.Item
                      href="#"
                      icon={HiInformationCircle}
                      className="text-white hover:text-black"
                    >
                      Partner And Affiliates
                    </Sidebar.Item>
                   
                    <Sidebar.Item
                      href="#"
                      icon={HiInformationCircle}
                      className="text-white hover:text-black"
                    >
                      SDG
                    </Sidebar.Item>
                    <Sidebar.Item
                      href="#"
                      icon={HiInformationCircle}
                      className="text-white hover:text-black"
                    >
                      Media
                    </Sidebar.Item>
                    <Sidebar.Item
                      href="/career"
                      icon={HiInformationCircle}
                      className="text-white hover:text-black"
                    >
                      Career
                    </Sidebar.Item>
                    <Sidebar.Item
                      href="#"
                      icon={HiInformationCircle}
                      className="text-white hover:text-black"
                    >
                      BTRC Approved Tariff
                    </Sidebar.Item>
                  </Sidebar.ItemGroup>
                </Sidebar.Items>
              </div>
            </div>
          </Sidebar>
        </Drawer.Items>
      </Drawer>
    </>
  );
}
