import Container from "@/app/component/Container";
import { IconCard } from "@/app/component/IconCard";
import Image from "next/image";
import { ImageCard2 } from "@/app/component/ImageCard2";
import Map from "@/app/component/Map";
import { BangladeshMap } from "@/app/component/BangladeshMap";
import { BangladeshCoverageDetails } from "@/app/component/BangladeshCoverageDetails";
import HeaderSubHead from "@/app/component/HeaderSubHead";
import React from "react";

export function Coverage() {
  return <Container>
    <section id="#coverage" className="mx-5 md:mx-10 2xl:mx-0">
      <HeaderSubHead data={{title: 'Coverage', description: 'Expanding reach, everywhere you need.'}} ></HeaderSubHead>
      <p className="text-body-large text-justify my-7 lg:my-14">ADN Telecom is a trusted partner in navigating the
        ever-evolving landscape of Information and Telecommunication technology. It is the flagship company of ADN Group
        which is one of the leading IT and Telecommunication service providers in Bangladesh offering a wide range of
        data, voice, and internet services to its local and international clients.</p>

      <div className="lg:flex lg:justify-between items-center">
        <div className="flex-grow-1 p-5 lg:w-[640px] max-w-xl mx-auto lg:mx-0">
          <BangladeshMap/>
        </div>
        <div className="flex-grow-1">
          <header className="text-center lg:text-left mb-8">
            <h2 className="text-h2 mb-4"><span className="text-primary-light">Coverage</span> Area</h2>
            <p className="text-body-large">Expanding reach, everywhere you need.</p>
          </header>
          <BangladeshCoverageDetails />
        </div>
      </div>
    </section>
  </Container>

}
