"use client";
import React, { useState, useEffect } from "react";
import Image from "next/image";
import timeline1 from "../../images/udoy.png"; // Replace with actual image paths
import timeline2 from "../../images/Udoy2.png";
import timeline3 from "../../images/diginet.png";
import "./cardslider.scss";
import left from "../../images/leftg.png";
import right from "../../images/rightg.png";
import Container from "../Container";

const CardSlider = () => {
  const cards = [
    {
      year: "2021",
      title: "Commencement of Digital Business Unit",
      image: timeline1,
    },
    {
      year: "2022",
      title: "Global arena serving UN peacekeeping mission",
      image: timeline2,
    },
    {
      year: "2023",
      title: "Launched nationwide B2C internet service under UDOY",
      image: timeline3,
    },
    {
      year: "2024",
      title: "Another milestone",
      image: timeline1,
    },
  ];

  const [currentIndex, setCurrentIndex] = useState(0);
  const [cardsPerPage, setCardsPerPage] = useState(1); // Default to 1 card per page for small screens

  // Adjust the number of cards per page based on the window size
  useEffect(() => {
    const handleResize = () => {
      setCardsPerPage(window.innerWidth >= 1024 ? 3 : 1); // 3 cards on large screens, 1 card on smaller screens
    };
    handleResize(); // Set initially based on screen size
    window.addEventListener("resize", handleResize); // Adjust on window resize
    return () => window.removeEventListener("resize", handleResize);
  }, []);

  useEffect(() => {
    const interval = setInterval(() => {
      nextSlide();
    }, 5000); // Change slide every 5 seconds

    return () => clearInterval(interval); // Clear interval on component unmount
  }, [currentIndex]); // Restart interval whenever currentIndex changes

  const totalCards = cards.length;

  const nextSlide = () => {
    setCurrentIndex((prevIndex) =>
      prevIndex === totalCards - 1 ? 0 : prevIndex + 1,
    );
  };

  const prevSlide = () => {
    setCurrentIndex((prevIndex) =>
      prevIndex === 0 ? totalCards - 1 : prevIndex - 1,
    );
  };

  // Get the cards to display, including wrapping logic
  const getDisplayedCards = () => {
    const displayedCards = [];
    for (let i = 0; i < cardsPerPage; i++) {
      const cardIndex = (currentIndex + i) % totalCards; // Ensures it wraps around when reaching the end
      displayedCards.push(cards[cardIndex]);
    }
    return displayedCards;
  };

  return (
    <section className="cardslider from-darkgreen to-lightgreen bg-gradient-to-b text-white overflow-hidden">
      <Container>
        <div className="text-center">
          <h2 className="text-h2">
            TOWARDS THE <span className="text-primary">EXCELLENCE</span>
          </h2>
          <p className="mx-auto mb-12 max-w-3xl">
            ADN Telecom is a trusted partner in navigating the ever-evolving
            landscape of Information and Telecommunication technology...
          </p>
          <div className="relative mx-auto w-full">
            {/* Card Container */}
            <div className="grid grid-cols-1 gap-6 pb-10 transition-transform duration-500 ease-in-out lg:grid-cols-3">
              {getDisplayedCards().map((card, index) => (
                <div
                  key={index}
                  className="card flex h-[350px] flex-col items-center justify-between rounded-lg border bg-gradient-to-b from-[#00B59B] to-[#0053B1] text-white"
                >
                  <div className="card-header rounded-b-2xl border-[#98C93C] bg-gradient-to-r from-[#00A551] to-[#98C93C] px-12 py-5 text-center">
                    <h2 className="text-3xl font-bold">{card.year}</h2>
                  </div>
                  <div className="card-body flex h-[200px] lg:w-[400px] flex-1 flex-col items-center justify-center">
                    <h2 className="text-3xl font-semibold">{card.title}</h2>
                  </div>
                  <div className="card-footer text-center">
                    <Image
                      src={card.image}
                      alt={card.title}
                      className="h-70 w-70 mb-4 object-cover"
                    />
                  </div>
                </div>
              ))}
            </div>

            {/* Navigation Arrows */}
            <button
              onClick={prevSlide}
              className="absolute left-[-10px] lg:left-[-40px] top-1/2 -translate-y-1/2 transform rounded-full p-1 text-[#3EC088]"
            >
              <Image src={left} alt="Slider Image" />
            </button>
            <button
              onClick={nextSlide}
              className="absolute right-[-10px] lg:right-[-40px] top-1/2 -translate-y-1/2 transform rounded-full p-1 text-[#3EC088]"
            >
              <Image src={right} alt="Slider Image" />
            </button>

            {/* Pagination Dots */}
            <div className="absolute bottom-0 left-1/2 flex -translate-x-1/2 transform gap-2">
              {Array.from({ length: totalCards }).map((_, index) => (
                <span
                  key={index}
                  className={`h-3 w-3 rounded-full ${
                    index === currentIndex ? "bg-white" : "bg-gray-400"
                  }`}
                ></span>
              ))}
            </div>
          </div>
        </div>
      </Container>
    </section>
  );
};

export default CardSlider;
