import Container from "../Container";
import DetailsData from "./DetailsData";

const Brands = () => {
  let data = [
    { title: "JICA" },
    { title: "Qatar Airways" },
    { title: "Embassy of Sweden" },
    { title: "Nestle" },
    { title: "Holcim" },
  ];

  return (
    <Container>
      <div className="marginTop pt-10">
        <h1 className="mb-10 text-center text-2xl font-bold text-white lg:mb-16 lg:text-3xl">
          We ve Worked with Some of the Biggest Brands
        </h1>

        <div className="pb-10">
          <div className="px-4 md:px-8">
            {/* component */}
            <div className="tex-sm grid grid-cols-2 gap-5 text-center sm:grid-cols-3 md:grid-cols-4 md:text-xl lg:grid-cols-5">
              {/* map item */}

              <DetailsData data={data} />
            </div>
          </div>
        </div>
      </div>
    </Container>
  );
};
export default Brands;
